/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.exceptions.IllegalIdentifierException;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.AlterTableSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.CreateIndexSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.CreateTableSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.CreateViewSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.DeleteSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.DropSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.InsertSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SelectSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.TruncateSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.UpdateSQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class SQL {
    protected final StringBuilder sqlBuilder = new StringBuilder();
    protected final List<Object> parameters = new ArrayList<Object>();

    public static SelectSQL select() {
        return new SelectSQL();
    }

    public static InsertSQL insert() {
        return new InsertSQL(false);
    }

    public static InsertSQL upsert() {
        return new InsertSQL(true);
    }

    public static UpdateSQL update() {
        return new UpdateSQL();
    }

    public static DeleteSQL delete() {
        return new DeleteSQL();
    }

    public static DropSQL drop() {
        return new DropSQL();
    }

    public static CreateTableSQL createTable() {
        return new CreateTableSQL();
    }

    public static AlterTableSQL alterTable() {
        return new AlterTableSQL();
    }

    public static CreateIndexSQL createIndex() {
        return new CreateIndexSQL();
    }

    public static CreateViewSQL createView() {
        return new CreateViewSQL();
    }

    public static TruncateSQL truncate() {
        return new TruncateSQL();
    }

    public PreparedStatement build(Connection connection, DatabaseType type) throws SQLException {
        this.parameters.clear();
        String sql = this.getSql(type);
        PreparedStatement stmt = connection.prepareStatement(sql);
        int expectedParams = this.countParametersInSql(sql);
        if (this.parameters.size() != expectedParams) {
            throw new SQLException("Parameter count mismatch. Expected " + expectedParams + " but got " + this.parameters.size());
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            stmt.setObject(i + 1, this.parameters.get(i));
        }
        return stmt;
    }

    private int countParametersInSql(String sql) {
        int count = 0;
        int index = -1;
        while ((index = sql.indexOf(63, index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    abstract String getSql(DatabaseType var1);

    void validateIdentifier(String identifier) {
        if (!identifier.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
            throw new IllegalIdentifierException("Invalid SQL identifier: " + identifier);
        }
    }
}

