/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CreateTableSQL
extends SQL {
    private final Map<String, ColumnDefinition> columns = new LinkedHashMap<String, ColumnDefinition>();
    private final List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
    private final List<String> uniqueConstraints = new ArrayList<String>();
    private final List<String> checks = new ArrayList<String>();
    private final List<String> primaryKeys = new ArrayList<String>();
    private String tableName;
    private boolean ifNotExists;
    private String tableOptions;

    CreateTableSQL() {
    }

    public CreateTableSQL table(String tableName) {
        this.validateIdentifier(tableName);
        this.tableName = tableName;
        return this;
    }

    public CreateTableSQL ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    public CreateTableSQL column(String name, String dataType) {
        return this.column(name, dataType, null);
    }

    public CreateTableSQL column(String name, String dataType, Integer length) {
        this.validateIdentifier(name);
        this.columns.put(name, new ColumnDefinition(dataType, length, false, false, null));
        return this;
    }

    public CreateTableSQL notNull(String columnName) {
        this.getColumn((String)columnName).nullable = false;
        return this;
    }

    public CreateTableSQL nullable(String columnName) {
        this.getColumn((String)columnName).nullable = true;
        return this;
    }

    public CreateTableSQL defaultValue(String columnName, String defaultValue) {
        this.getColumn((String)columnName).defaultValue = defaultValue;
        return this;
    }

    public CreateTableSQL autoIncrement(String columnName) {
        this.getColumn((String)columnName).autoIncrement = true;
        return this;
    }

    public CreateTableSQL primaryKey(String ... columnNames) {
        for (String columnName : columnNames) {
            this.validateIdentifier(columnName);
            if (!this.columns.containsKey(columnName)) {
                throw new IllegalArgumentException("Column not defined: " + columnName);
            }
            this.primaryKeys.add(columnName);
        }
        return this;
    }

    public CreateTableSQL foreignKey(String column, String referenceTable, String referenceColumn) {
        this.validateIdentifier(column);
        this.validateIdentifier(referenceTable);
        this.validateIdentifier(referenceColumn);
        this.foreignKeys.add(new ForeignKey(column, referenceTable, referenceColumn));
        return this;
    }

    public CreateTableSQL unique(String ... columnNames) {
        for (String columnName : columnNames) {
            this.validateIdentifier(columnName);
            this.uniqueConstraints.add(columnName);
        }
        return this;
    }

    public CreateTableSQL check(String condition) {
        this.checks.add(condition);
        return this;
    }

    public CreateTableSQL options(String options) {
        this.tableOptions = options;
        return this;
    }

    private String adaptTableOptions(String options, DatabaseType type) {
        if (type == DatabaseType.SQLITE) {
            return options.replaceAll("ENGINE=\\w+", "").replaceAll("DEFAULT CHARSET=\\w+", "").trim();
        }
        return options;
    }

    @Override
    public PreparedStatement build(Connection connection, DatabaseType type) throws SQLException {
        return connection.prepareStatement(this.getSql(type));
    }

    private ColumnDefinition getColumn(String columnName) {
        ColumnDefinition column = this.columns.get(columnName);
        if (column == null) {
            throw new IllegalArgumentException("Column not defined: " + columnName);
        }
        return column;
    }

    @Override
    protected void validateIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Identifier cannot be null or empty");
        }
        if (!identifier.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
            throw new IllegalArgumentException("Invalid SQL identifier: " + identifier);
        }
    }

    @Override
    public String getSql(DatabaseType type) {
        if (this.tableName == null) {
            throw new IllegalStateException("Table name must be specified");
        }
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("At least one column must be defined");
        }
        StringBuilder sql = new StringBuilder("CREATE TABLE");
        if (this.ifNotExists) {
            sql.append(" IF NOT EXISTS");
        }
        sql.append(" ").append(this.tableName).append(" (\n");
        List columnDefs = this.columns.entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            ColumnDefinition def = (ColumnDefinition)entry.getValue();
            return this.buildColumnDefinition(name, def, type);
        }).collect(Collectors.toList());
        if (!this.primaryKeys.isEmpty()) {
            columnDefs.add("  PRIMARY KEY (" + String.join((CharSequence)", ", this.primaryKeys) + ")");
        }
        if (!this.uniqueConstraints.isEmpty()) {
            columnDefs.add("  UNIQUE (" + String.join((CharSequence)", ", this.uniqueConstraints) + ")");
        }
        for (ForeignKey fk : this.foreignKeys) {
            columnDefs.add(String.format("  FOREIGN KEY (%s) REFERENCES %s(%s)", fk.column, fk.referenceTable, fk.referenceColumn));
        }
        for (String check : this.checks) {
            columnDefs.add("  CHECK (" + check + ")");
        }
        sql.append(String.join((CharSequence)",\n", columnDefs));
        sql.append("\n)");
        if (this.tableOptions != null && !this.tableOptions.isEmpty()) {
            sql.append(" ").append(this.adaptTableOptions(this.tableOptions, type));
        }
        return sql.toString();
    }

    private String buildColumnDefinition(String name, ColumnDefinition def, DatabaseType type) {
        StringBuilder colDef = new StringBuilder("  ").append(name).append(" ").append(def.dataType);
        if (def.autoIncrement) {
            if (type == DatabaseType.MYSQL) {
                colDef.append(" AUTO_INCREMENT");
            } else if (type == DatabaseType.SQLITE) {
                colDef.append(" AUTOINCREMENT");
            }
        }
        if (!this.primaryKeys.contains(name) && !def.nullable) {
            colDef.append(" NOT NULL");
        }
        if (def.defaultValue != null) {
            colDef.append(" DEFAULT ").append(def.defaultValue);
        }
        return colDef.toString();
    }

    private static class ColumnDefinition {
        final String dataType;
        final Integer length;
        boolean nullable;
        boolean autoIncrement;
        String defaultValue;

        ColumnDefinition(String dataType, Integer length, boolean nullable, boolean autoIncrement, String defaultValue) {
            this.dataType = dataType;
            this.length = length;
            this.nullable = nullable;
            this.autoIncrement = autoIncrement;
            this.defaultValue = defaultValue;
        }
    }

    private record ForeignKey(String column, String referenceTable, String referenceColumn) {
    }
}

