/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.ssl;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.PGProperty;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.PGStream;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.SocketFactoryFactory;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.jdbc.SslMode;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.jdbc.SslNegotiation;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.ssl.LibPQFactory;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.ssl.PGjdbcHostnameVerifier;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.GT;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.ObjectFactory;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLException;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLState;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.internal.Nullness;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    private static final Logger LOGGER = Logger.getLogger(MakeSSL.class.getName());

    public static void convert(PGStream stream, Properties info) throws PSQLException, IOException {
        SslMode sslMode;
        SSLSocket newConnection;
        LOGGER.log(Level.FINE, "converting regular socket connection to ssl");
        SSLSocketFactory factory = SocketFactoryFactory.getSslSocketFactory(info);
        try {
            newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            int connectTimeoutSeconds = PGProperty.CONNECT_TIMEOUT.getInt(info);
            newConnection.setSoTimeout(connectTimeoutSeconds * 1000);
            if (SslNegotiation.of(Nullness.castNonNull(PGProperty.SSL_NEGOTIATION.getOrDefault(info))) == SslNegotiation.DIRECT) {
                SSLParameters sslParameters = newConnection.getSSLParameters();
                sslParameters.setApplicationProtocols(new String[]{"postgresql"});
                newConnection.setSSLParameters(sslParameters);
            }
            newConnection.setUseClientMode(true);
            newConnection.startHandshake();
        }
        catch (IOException ex) {
            throw new PSQLException(GT.tr("SSL error: {0}", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        if (factory instanceof LibPQFactory) {
            ((LibPQFactory)factory).throwKeyManagerException();
        }
        if ((sslMode = SslMode.of(info)).verifyPeerName()) {
            MakeSSL.verifyPeerName(stream, info, newConnection);
        }
        int socketTimeout = PGProperty.SOCKET_TIMEOUT.getInt(info);
        newConnection.setSoTimeout(socketTimeout * 1000);
        stream.changeSocket(newConnection);
    }

    private static void verifyPeerName(PGStream stream, Properties info, SSLSocket newConnection) throws PSQLException {
        HostnameVerifier hvn;
        String sslhostnameverifier = PGProperty.SSL_HOSTNAME_VERIFIER.getOrDefault(info);
        if (sslhostnameverifier == null) {
            hvn = PGjdbcHostnameVerifier.INSTANCE;
            sslhostnameverifier = "PgjdbcHostnameVerifier";
        } else {
            try {
                hvn = MakeSSL.instantiate(HostnameVerifier.class, sslhostnameverifier, info, false, null);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", sslhostnameverifier), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        if (hvn.verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
            return;
        }
        throw new PSQLException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", stream.getHostSpec().getHost(), sslhostnameverifier), PSQLState.CONNECTION_FAILURE);
    }
}

