/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.BaseConnection;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.ReplicationProtocol;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.PGReplicationStream;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.ChainedStreamBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.logical.ChainedLogicalStreamBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.logical.LogicalReplicationOptions;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.logical.LogicalStreamBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.logical.StartLogicalReplicationCallback;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.physical.PhysicalReplicationOptions;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.physical.PhysicalStreamBuilder;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

