/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.largeobject;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.jdbc.ResourceLock;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.largeobject.LargeObject;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.GT;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlobInputStream
extends InputStream {
    static final int DEFAULT_MAX_BUFFER_SIZE = 524288;
    static final int INITIAL_BUFFER_SIZE = 65536;
    private @Nullable LargeObject lo;
    private final ResourceLock lock = new ResourceLock();
    private long absolutePosition;
    private byte @Nullable [] buffer;
    private int bufferPosition;
    private int lastBufferSize;
    private final int maxBufferSize;
    private long markPosition;
    private final long limit;

    public BlobInputStream(LargeObject lo) {
        this(lo, 524288);
    }

    public BlobInputStream(LargeObject lo, int bsize) {
        this(lo, bsize, Long.MAX_VALUE);
    }

    public BlobInputStream(LargeObject lo, int bsize, long limit) {
        this.lo = lo;
        this.maxBufferSize = bsize;
        this.lastBufferSize = 32768;
        this.limit = limit == -1L ? Long.MAX_VALUE : limit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        try (ResourceLock ignore = this.lock.obtain();){
            LargeObject lo = this.getLo();
            if (this.absolutePosition >= this.limit) {
                this.buffer = null;
                this.bufferPosition = 0;
                int n = -1;
                return n;
            }
            if (this.buffer == null || this.bufferPosition >= this.buffer.length) {
                int nextBufferSize = this.getNextBufferSize(1);
                this.buffer = lo.read(nextBufferSize);
                this.bufferPosition = 0;
                if (this.buffer.length == 0) {
                    int n = -1;
                    return n;
                }
            }
            int ret = this.buffer[this.bufferPosition] & 0xFF;
            ++this.bufferPosition;
            ++this.absolutePosition;
            if (this.bufferPosition >= this.buffer.length) {
                this.buffer = null;
                this.bufferPosition = 0;
            }
            int n = ret;
            return n;
        }
        catch (SQLException e) {
            long loId = this.lo == null ? -1L : this.lo.getLongOID();
            throw new IOException(GT.tr("Can not read data from large object {0}, position: {1}, buffer size: {2}", loId, this.absolutePosition, this.lastBufferSize), e);
        }
    }

    private int getNextBufferSize(int len) {
        int nextBufferSize = Math.min(this.maxBufferSize, this.lastBufferSize * 2);
        if (len > nextBufferSize) {
            nextBufferSize = Math.min(this.maxBufferSize, Integer.highestOneBit(len * 2));
        }
        this.lastBufferSize = nextBufferSize;
        return nextBufferSize;
    }

    @Override
    public int read(byte[] dest, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        try (ResourceLock ignore = this.lock.obtain();){
            int bytesCopied = 0;
            LargeObject lo = this.getLo();
            if (this.absolutePosition >= this.limit) {
                int n = -1;
                return n;
            }
            len = Math.min(len, (int)Math.min(this.limit - this.absolutePosition, Integer.MAX_VALUE));
            if (this.buffer != null) {
                int bytesInBuffer = this.buffer.length - this.bufferPosition;
                int bytesToCopy = Math.min(len, bytesInBuffer);
                System.arraycopy(this.buffer, this.bufferPosition, dest, off, bytesToCopy);
                this.bufferPosition += bytesToCopy;
                if (this.bufferPosition >= this.buffer.length) {
                    this.buffer = null;
                    this.bufferPosition = 0;
                }
                this.absolutePosition += (long)bytesToCopy;
                off += bytesToCopy;
                len -= bytesToCopy;
                bytesCopied = bytesToCopy;
            }
            if (len > 0) {
                int bytesRead;
                int nextBufferSize = this.getNextBufferSize(len);
                this.buffer = null;
                this.bufferPosition = 0;
                try {
                    if (len >= nextBufferSize) {
                        bytesRead = lo.read(dest, off, len);
                    } else {
                        this.buffer = lo.read(nextBufferSize);
                        bytesRead = Math.min(len, this.buffer.length);
                        System.arraycopy(this.buffer, 0, dest, off, bytesRead);
                        if (bytesRead == this.buffer.length) {
                            this.buffer = null;
                            this.bufferPosition = 0;
                        } else {
                            this.bufferPosition = bytesRead;
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new IOException(GT.tr("Can not read data from large object {0}, position: {1}, buffer size: {2}", lo.getLongOID(), this.absolutePosition, len), ex);
                }
                bytesCopied += bytesRead;
                this.absolutePosition += (long)bytesRead;
            }
            int n = bytesCopied == 0 ? -1 : bytesCopied;
            return n;
        }
    }

    @Override
    public void close() throws IOException {
        long loId = 0L;
        try (ResourceLock ignore = this.lock.obtain();){
            LargeObject lo = this.lo;
            if (lo != null) {
                loId = lo.getLongOID();
                lo.close();
            }
            this.lo = null;
        }
        catch (SQLException e) {
            throw new IOException(GT.tr("Can not close large object {0}", loId), e);
        }
    }

    @Override
    public void mark(int readlimit) {
        try (ResourceLock ignore = this.lock.obtain();){
            this.markPosition = this.absolutePosition;
        }
    }

    @Override
    public void reset() throws IOException {
        try (ResourceLock ignore = this.lock.obtain();){
            LargeObject lo = this.getLo();
            long loId = lo.getLongOID();
            try {
                if (this.markPosition <= Integer.MAX_VALUE) {
                    lo.seek((int)this.markPosition);
                } else {
                    lo.seek64(this.markPosition, 0);
                }
                this.buffer = null;
                this.absolutePosition = this.markPosition;
            }
            catch (SQLException e) {
                throw new IOException(GT.tr("Can not reset stream for large object {0} to position {1}", loId, this.markPosition), e);
            }
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    private LargeObject getLo() throws IOException {
        if (this.lo == null) {
            throw new IOException("BlobOutputStream is closed");
        }
        return this.lo;
    }
}

