/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.postgre.core;

import io.github.lijinhong11.supermines.libraries.database.libs.postgre.PGProperty;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.PGStream;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.QueryExecutor;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.core.v3.ConnectionFactoryImpl;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.GT;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.HostSpec;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLException;
import io.github.lijinhong11.supermines.libraries.database.libs.postgre.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ConnectionFactory.class.getName());

    public static QueryExecutor openConnection(HostSpec[] hostSpecs, Properties info) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = PGProperty.PROTOCOL_VERSION.getOrDefault(info);
        if (protoName != null && !protoName.isEmpty() && (protoName.equalsIgnoreCase("3") || protoName.equalsIgnoreCase("3.0") || protoName.equalsIgnoreCase("3.2")) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, info)) != null) {
            return queryExecutor;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, Properties var2) throws SQLException;

    protected void closeStream(@Nullable PGStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to closed stream with error: {0}", e);
            }
        }
    }
}

