/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ColumnDecoder;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.DataType;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.MutableInt;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Codec;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.Geometry;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.GeometryCollection;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.LineString;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.MultiLineString;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.MultiPoint;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.MultiPolygon;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.Point;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.Polygon;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;

public class GeometryCollectionCodec
implements Codec<GeometryCollection> {
    public static final GeometryCollectionCodec INSTANCE = new GeometryCollectionCodec();

    @Override
    public String className() {
        return GeometryCollection.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(GeometryCollection.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof GeometryCollection;
    }

    @Override
    public GeometryCollection decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal, context);
    }

    @Override
    public GeometryCollection decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length.get() - 4, column);
            if (geo instanceof GeometryCollection) {
                return (GeometryCollection)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as GeometryCollection", geo.getClass().getName()));
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as GeometryCollection", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_GeomCollFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public int getApproximateTextProtocolLength(Object value, Long length) {
        return -1;
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        GeometryCollection geometryCollection = (GeometryCollection)value;
        int length = 13;
        for (Geometry geo : geometryCollection.getGeometries()) {
            if (geo instanceof Point) {
                length += 21;
                continue;
            }
            if (geo instanceof LineString) {
                length += 9 + ((LineString)geo).getPoints().length * 16;
                continue;
            }
            if (geo instanceof Polygon) {
                length += 9;
                for (LineString lineString : ((Polygon)geo).getLines()) {
                    length += 4 + lineString.getPoints().length * 16;
                }
                continue;
            }
            if (geo instanceof MultiPoint) {
                length += 9 + ((MultiPoint)geo).getPoints().length * 21;
                continue;
            }
            if (geo instanceof MultiLineString) {
                length += 9;
                for (Geometry geometry : ((MultiLineString)geo).getLines()) {
                    length += 9 + ((LineString)geometry).getPoints().length * 16;
                }
                continue;
            }
            if (!(geo instanceof MultiPolygon)) continue;
            length += 9;
            for (Geometry geometry : ((MultiPolygon)geo).getPolygons()) {
                length += 9;
                for (LineString ls : ((Polygon)geometry).getLines()) {
                    length += 4 + ls.getPoints().length * 16;
                }
            }
        }
        encoder.writeLength(length);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(7);
        encoder.writeInt(geometryCollection.getGeometries().length);
        for (Geometry geo : geometryCollection.getGeometries()) {
            if (geo instanceof Point) {
                Point pt = (Point)geo;
                encoder.writeByte(1);
                encoder.writeInt(1);
                encoder.writeDouble(pt.getX());
                encoder.writeDouble(pt.getY());
                continue;
            }
            if (geo instanceof LineString) {
                LineString ls = (LineString)geo;
                encoder.writeByte(1);
                encoder.writeInt(2);
                encoder.writeInt(ls.getPoints().length);
                for (Geometry geometry : ls.getPoints()) {
                    encoder.writeDouble(((Point)geometry).getX());
                    encoder.writeDouble(((Point)geometry).getY());
                }
                continue;
            }
            if (geo instanceof Polygon) {
                Polygon poly = (Polygon)geo;
                encoder.writeByte(1);
                encoder.writeInt(3);
                encoder.writeInt(poly.getLines().length);
                for (Geometry geometry : poly.getLines()) {
                    encoder.writeInt(((LineString)geometry).getPoints().length);
                    for (Point point : ((LineString)geometry).getPoints()) {
                        encoder.writeDouble(point.getX());
                        encoder.writeDouble(point.getY());
                    }
                }
                continue;
            }
            if (geo instanceof MultiPoint) {
                MultiPoint mp = (MultiPoint)geo;
                encoder.writeByte(1);
                encoder.writeInt(4);
                encoder.writeInt(mp.getPoints().length);
                for (Geometry geometry : mp.getPoints()) {
                    encoder.writeByte(1);
                    encoder.writeInt(1);
                    encoder.writeDouble(((Point)geometry).getX());
                    encoder.writeDouble(((Point)geometry).getY());
                }
                continue;
            }
            if (geo instanceof MultiLineString) {
                MultiLineString mlines = (MultiLineString)geo;
                encoder.writeByte(1);
                encoder.writeInt(5);
                encoder.writeInt(mlines.getLines().length);
                for (Geometry geometry : mlines.getLines()) {
                    encoder.writeByte(1);
                    encoder.writeInt(2);
                    encoder.writeInt(((LineString)geometry).getPoints().length);
                    for (Geometry geometry2 : ((LineString)geometry).getPoints()) {
                        encoder.writeDouble(((Point)geometry2).getX());
                        encoder.writeDouble(((Point)geometry2).getY());
                    }
                }
                continue;
            }
            if (!(geo instanceof MultiPolygon)) continue;
            MultiPolygon multiPolygon = (MultiPolygon)geo;
            encoder.writeByte(1);
            encoder.writeInt(6);
            encoder.writeInt(multiPolygon.getPolygons().length);
            for (Geometry geometry : multiPolygon.getPolygons()) {
                encoder.writeByte(1);
                encoder.writeInt(3);
                encoder.writeInt(((Polygon)geometry).getLines().length);
                for (Geometry geometry3 : ((Polygon)geometry).getLines()) {
                    encoder.writeInt(((LineString)geometry3).getPoints().length);
                    for (Point pt : ((LineString)geometry3).getPoints()) {
                        encoder.writeDouble(pt.getX());
                        encoder.writeDouble(pt.getY());
                    }
                }
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

