/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.authentication.addon;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.Configuration;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.impl.StandardReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Reader;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.AuthenticationPlugin;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.authentication.addon.gssapi.GssUtility;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.authentication.addon.gssapi.GssapiAuth;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.authentication.addon.gssapi.StandardGssapiAuthentication;
import java.io.IOException;
import java.sql.SQLException;

public class SendGssApiAuthPacket
implements AuthenticationPlugin {
    private static final GssapiAuth gssapiAuth;
    private final byte[] seed;
    private final String optionServicePrincipalName;

    public SendGssApiAuthPacket(byte[] seed, Configuration conf) {
        this.seed = seed;
        this.optionServicePrincipalName = conf.servicePrincipalName();
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context, boolean sslFingerPrintValidation) throws IOException, SQLException {
        StandardReadableByteBuf buf = new StandardReadableByteBuf(this.seed, this.seed.length);
        String serverSpn = buf.readStringNullEnd();
        String servicePrincipalName = this.optionServicePrincipalName != null ? this.optionServicePrincipalName : serverSpn;
        String mechanisms = buf.readStringNullEnd();
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        gssapiAuth.authenticate(out, in, servicePrincipalName, mechanisms);
        return in.readReusablePacket();
    }

    static {
        GssapiAuth init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t) {
            init = new StandardGssapiAuthentication();
        }
        gssapiAuth = init;
    }
}

