/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.BasePreparedStatement;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Client;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Reader;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.PrepareResultPacket;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CachedPrepareResultPacket
extends PrepareResultPacket {
    private final AtomicBoolean closing = new AtomicBoolean();
    private final AtomicBoolean cached = new AtomicBoolean();
    private final List<BasePreparedStatement> statements = new ArrayList<BasePreparedStatement>();

    public CachedPrepareResultPacket(ReadableByteBuf buffer, Reader reader, Context context) throws IOException {
        super(buffer, reader, context);
    }

    @Override
    public void close(Client con) throws SQLException {
        if (!this.cached.get() && this.closing.compareAndSet(false, true)) {
            con.closePrepare(this);
        }
    }

    @Override
    public void decrementUse(Client con, BasePreparedStatement preparedStatement) throws SQLException {
        this.statements.remove(preparedStatement);
        if (this.statements.isEmpty() && !this.cached.get()) {
            this.close(con);
        }
    }

    public void incrementUse(BasePreparedStatement preparedStatement) {
        if (this.closing.get()) {
            return;
        }
        if (preparedStatement != null) {
            this.statements.add(preparedStatement);
        }
    }

    public void unCache(Client con) {
        this.cached.set(false);
        if (this.statements.size() <= 0) {
            try {
                this.close(con);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean cache() {
        if (this.closing.get()) {
            return false;
        }
        return this.cached.compareAndSet(false, true);
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    public void reset() {
        this.statementId = -1;
        for (BasePreparedStatement stmt : this.statements) {
            stmt.reset();
        }
    }
}

