/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.BasePreparedStatement;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.ServerPreparedStatement;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.Statement;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Completion;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Reader;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.ClosableLock;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.export.ExceptionFactory;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.ClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.CachedPrepareResultPacket;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.ErrorPacket;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.PrepareResultPacket;
import java.io.IOException;
import java.sql.SQLException;
import java.util.function.Consumer;

public final class PreparePacket
implements ClientMessage {
    private final String sql;

    public PreparePacket(String sql) {
        this.sql = sql;
    }

    @Override
    public int encode(Writer writer, Context context) throws IOException {
        writer.initPacket();
        writer.writeByte(22);
        writer.writeString(this.sql);
        writer.flush();
        return 1;
    }

    @Override
    public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ClosableLock lock, boolean traceEnable, ClientMessage message, Consumer<String> redirectFct) throws IOException, SQLException {
        ReadableByteBuf buf = reader.readReusablePacket(traceEnable);
        if (buf.getUnsignedByte() == 255) {
            ErrorPacket errorPacket = new ErrorPacket(buf, context);
            throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode(), true);
        }
        if (context.getConf().useServerPrepStmts() && context.getConf().cachePrepStmts() && this.sql.length() < 8192) {
            CachedPrepareResultPacket prepare = new CachedPrepareResultPacket(buf, reader, context);
            PrepareResultPacket previousCached = (PrepareResultPacket)context.putPrepareCacheCmd(this.sql, prepare, stmt instanceof ServerPreparedStatement ? (ServerPreparedStatement)stmt : null);
            if (stmt != null) {
                ((BasePreparedStatement)stmt).setPrepareResult(previousCached != null ? previousCached : prepare);
            }
            return previousCached != null ? previousCached : prepare;
        }
        PrepareResultPacket prepareResult = new PrepareResultPacket(buf, reader, context);
        if (stmt != null) {
            ((BasePreparedStatement)stmt).setPrepareResult(prepareResult);
        }
        return prepareResult;
    }

    @Override
    public String description() {
        return "PREPARE " + this.sql;
    }
}

