/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.impl;

import io.github.lijinhong11.supermines.libraries.database.DatabaseParameters;
import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.impl.AbstractSQLConnection;
import io.github.lijinhong11.supermines.libraries.database.libs.hikari.HikariConfig;
import io.github.lijinhong11.supermines.libraries.database.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

class SQLiteConnection
extends AbstractSQLConnection {
    private static final String JDBC_URL_FORMAT = "jdbc:sqlite:%s";
    private static final String JDBC_DRIVER_CLASS_NAME = "org.sqlite.JDBC";
    private final HikariDataSource dataSource;

    public SQLiteConnection(String absolutePath, DatabaseParameters parameters) {
        if (absolutePath == null || absolutePath.isBlank()) {
            throw new IllegalArgumentException("the absolute path of database file cannot be null or blank");
        }
        HikariConfig cfg = new HikariConfig();
        cfg.setJdbcUrl(String.format(JDBC_URL_FORMAT, absolutePath));
        cfg.setDriverClassName(JDBC_DRIVER_CLASS_NAME);
        cfg.setIdleTimeout(parameters.getIdleTimeout());
        cfg.setMaximumPoolSize(parameters.getMaxPoolSize());
        cfg.setAutoCommit(true);
        cfg.setKeepaliveTime(parameters.getMaxKeepAlive());
        this.dataSource = new HikariDataSource(cfg);
    }

    @Override
    Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.SQLITE;
    }
}

