/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.impl;

import io.github.lijinhong11.supermines.libraries.database.DatabaseParameters;
import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.impl.AbstractSQLConnection;
import io.github.lijinhong11.supermines.libraries.database.libs.hikari.HikariConfig;
import io.github.lijinhong11.supermines.libraries.database.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

class MySQLConnection
extends AbstractSQLConnection {
    private static final String JDBC_URL_FORMAT = "jdbc:mysql://%s:%d/%s?useSSL=false&serverTimezone=UTC";
    private static final String JDBC_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private final HikariDataSource dataSource;

    public MySQLConnection(String host, int port, String database, String username, String password, DatabaseParameters parameters) {
        HikariConfig cfg = new HikariConfig();
        cfg.setJdbcUrl(JDBC_URL_FORMAT.formatted(host, port, database));
        cfg.setDriverClassName(JDBC_DRIVER_CLASS_NAME);
        cfg.setUsername(username);
        cfg.setPassword(password);
        cfg.setMaximumPoolSize(parameters.getMaxPoolSize());
        cfg.setAutoCommit(true);
        cfg.setIdleTimeout(parameters.getIdleTimeout());
        cfg.setKeepaliveTime(parameters.getMaxKeepAlive());
        try (HikariDataSource dataSource = new HikariDataSource(cfg);){
            this.dataSource = dataSource;
        }
    }

    @Override
    Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.MYSQL;
    }
}

