/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.integrates.block;

import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.integrates.block.BlockAddon;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MinecraftBlockAddon
extends BlockAddon {
    public static final MinecraftBlockAddon INSTANCE = new MinecraftBlockAddon();

    private MinecraftBlockAddon() {
    }

    public static AddonBlock createForMaterial(Material material) {
        if (material == null) {
            return null;
        }
        if (material.isAir()) {
            return null;
        }
        return new AddonBlock("", material.toString(), l -> l.getBlock().setType(material), new ItemStack(material));
    }

    @Override
    public AddonBlock getBlock(String id) {
        Material material = Material.matchMaterial((String)id.toUpperCase());
        return MinecraftBlockAddon.createForMaterial(material);
    }

    @Override
    public AddonBlock getBlock(Location loc) {
        return MinecraftBlockAddon.createForMaterial(loc.getBlock().getType());
    }

    @Override
    public void removeBlock(Location loc) {
        loc.getBlock().setType(Material.AIR);
    }

    @Override
    public void addBlockSuggestions(List<String> suggestions) {
        for (Material material : Material.values()) {
            suggestions.add(material.toString().toLowerCase());
        }
    }

    @Override
    public List<String> getKey() {
        return List.of("minecraft", "");
    }
}

