/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.integrates.block;

import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class AddonBlock {
    private final String key;
    private final String id;
    private final ItemStack item;
    private final Consumer<Location> placer;

    AddonBlock(String key, String id, Consumer<Location> placer, ItemStack item) {
        this.key = key;
        this.id = id;
        this.item = item;
        this.placer = placer;
    }

    public String getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    public void place(Location loc) {
        this.placer.accept(loc);
    }

    public ItemStack toItem() {
        return this.item;
    }

    public String toString() {
        return (String)(this.key.isBlank() ? "" : this.key + ":") + this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AddonBlock)) {
            return false;
        }
        AddonBlock block = (AddonBlock)obj;
        return Objects.equals(this.getKey(), block.getKey()) && Objects.equals(this.getId(), block.getId()) && Objects.equals(this.placer, block.placer);
    }
}

