/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.gui;

import dev.triumphteam.gui.builder.gui.ChestGuiBuilder;
import dev.triumphteam.gui.builder.gui.PaginatedBuilder;
import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.components.util.GuiFiller;
import dev.triumphteam.gui.guis.BaseGui;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import dev.triumphteam.gui.guis.PaginatedGui;
import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.gui.ListGUI;
import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.integrates.block.BlockAddon;
import io.github.lijinhong11.supermines.integrates.block.MinecraftBlockAddon;
import io.github.lijinhong11.supermines.message.MessageReplacement;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.Constants;
import io.github.lijinhong11.supermines.utils.chat.ChatInput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GuiManager {
    private static final int GENERAL_MINES_ROW = 2;
    private static final int GENERAL_MINES_COL = 3;
    private static final int GENERAL_TREASURES_ROW = 2;
    private static final int GENERAL_TREASURES_COL = 5;
    private static final int GENERAL_RANKS_ROW = 2;
    private static final int GENERAL_RANKS_COL = 7;
    private static final int MANAGEMENT_ICON_ROW = 2;
    private static final int MANAGEMENT_ICON_COL = 5;
    private static final int MANAGEMENT_DISPLAY_NAME_ROW = 3;
    private static final int MANAGEMENT_DISPLAY_NAME_COL = 2;
    private static final int MANAGEMENT_BACK_ROW = 1;
    private static final int MANAGEMENT_BACK_COL = 9;
    private static final int MINE_DISPLAY_ICON_ROW = 3;
    private static final int MINE_DISPLAY_ICON_COL = 4;
    private static final int MINE_REGEN_SECONDS_ROW = 3;
    private static final int MINE_REGEN_SECONDS_COL = 6;
    private static final int MINE_ONLY_FILL_AIR_ROW = 3;
    private static final int MINE_ONLY_FILL_AIR_COL = 8;
    private static final int MINE_REQUIRED_RANK_ROW = 4;
    private static final int MINE_REQUIRED_RANK_COL = 3;
    private static final int MINE_BLOCK_SPAWN_ROW = 4;
    private static final int MINE_BLOCK_SPAWN_COL = 5;
    private static final int TREASURE_CHANCE_ROW = 3;
    private static final int TREASURE_CHANCE_COL = 4;
    private static final int TREASURE_ITEMSTACK_ROW = 3;
    private static final int TREASURE_ITEMSTACK_COL = 6;
    private static final int TREASURE_MATCHED_MATERIALS_ROW = 3;
    private static final int TREASURE_MATCHED_MATERIALS_COL = 8;
    private static final int RANK_LEVEL_ROW = 3;
    private static final int RANK_LEVEL_COL = 4;
    private static final int BLOCK_SPAWN_ADD_ROW = 6;
    private static final int BLOCK_SPAWN_ADD_COL = 1;
    private static final int PAGINATION_ROW = 6;
    private static final int PAGINATION_CLOSE_COL = 1;
    private static final int PAGINATION_PREVIOUS_COL = 3;
    private static final int PAGINATION_NEXT_COL = 7;
    private static final int PAGINATION_BACK_COL = 9;
    private static final int PAGINATION_START_ROW = 6;
    private static final int PAGINATION_START_COL = 1;
    private static final int PAGINATION_END_ROW = 6;
    private static final int PAGINATION_END_COL = 9;
    private static final String CANCEL_COMMAND = "##CANCEL";

    public static void openGeneral(Player p) {
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.general.title", new MessageReplacement[0]))).rows(3)).create();
        GuiManager.putItem(2, 3, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.MINES.apply(p)), e -> GuiManager.openMineList(p));
        GuiManager.putItem(2, 5, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.TREASURES.apply(p)), e -> GuiManager.openTreasureList(p));
        GuiManager.putItem(2, 7, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.RANKS.apply(p)), e -> GuiManager.openRankList(p));
        gui.open((HumanEntity)p);
    }

    public static void openMineList(Player p) {
        PaginatedGui gui = GuiManager.createPaginatedGui(p, "gui.mines.title", 45);
        GuiManager.fillPageButtons(p, gui, () -> GuiManager.openGeneral(p));
        for (Mine mine : SuperMines.getInstance().getMineManager().getAllMines()) {
            Material mat = mine.getDisplayIcon() == null ? Constants.Items.DEFAULT_MINE_ICON : mine.getDisplayIcon();
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from((Material)mat).name(mine.getDisplayName())).lore(SuperMines.getInstance().getLanguageManager().getMineInfo(p, mine))).asGuiItem(e -> {
                GuiManager.openMineManagementGui(p, mine);
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
    }

    public static void openMineManagementGui(Player p, Mine mine) {
        MessageReplacement mineName = MessageReplacement.replace("%mine%", mine.getRawDisplayName());
        Gui gui = GuiManager.createManagementGui(p, "gui.mine-management.title", mineName);
        Runnable reopen = () -> GuiManager.openMineManagementGui(p, mine);
        Runnable back = () -> GuiManager.openMineList(p);
        GuiManager.placeCommon(p, gui, mine, mine.getDisplayIcon(), reopen, back);
        GuiManager.putItem(3, 4, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.SET_DISPLAY_ICON.apply(p, mine.getDisplayIcon())), e -> {
            AddonBlock m = GuiManager.openMaterialChooser(p, reopen);
            if (m != null) {
                mine.setDisplayIcon(m.toItem().getType());
                reopen.run();
            }
        });
        GuiManager.putItem(3, 6, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.SET_REGEN_SECONDS.apply(p, mine.getRegenerateSeconds())), e -> {
            if (!GuiManager.checkPermission(p, "supermines.set_reset_time")) {
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.set_reset_time.prompt", new MessageReplacement[0]);
            GuiManager.handleIntegerInput(p, result -> {
                mine.setRegenerateSeconds((int)result);
                SuperMines.getInstance().getTaskMaker().restartMineResetTask(mine);
                reopen.run();
            });
        });
        GuiManager.putItem(3, 8, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.ONLY_FILL_AIR.apply(p, mine.isOnlyFillAirWhenRegenerate())), e -> {
            if (!GuiManager.checkPermission(p, "supermines.set_only_fill_air")) {
                return;
            }
            mine.setOnlyFillAirWhenRegenerate(!mine.isOnlyFillAirWhenRegenerate());
            reopen.run();
        });
        GuiManager.putItem(4, 3, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.SET_REQUIRED_RANK_LEVEL.apply(p, mine.getRequiredRankLevel())), e -> {
            if (!GuiManager.checkPermission(p, "supermines.set_required_level")) {
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.set_required_lvl.prompt", new MessageReplacement[0]);
            GuiManager.handleIntegerInput(p, result -> {
                mine.setRequiredRankLevel((int)result);
                SuperMines.getInstance().getTaskMaker().restartMineResetTask(mine);
                reopen.run();
            });
        });
        GuiManager.putItem(4, 5, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.BLOCK_SPAWN_ENTRIES.apply(p)), e -> {
            if (!GuiManager.checkPermission(p, "supermines.block_generates")) {
                return;
            }
            GuiManager.openBlockSpawnEntries(p, mine);
        });
        gui.open((HumanEntity)p);
    }

    private static void openBlockSpawnEntries(Player p, Mine mine) {
        PaginatedGui gui = GuiManager.createPaginatedGui(p, "gui.mine-management.block_spawn.title", 45);
        Runnable reopen = () -> GuiManager.openBlockSpawnEntries(p, mine);
        Runnable back = () -> GuiManager.openMineManagementGui(p, mine);
        GuiManager.fillPageButtons(p, gui, back);
        GuiManager.putItem(6, 1, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.ADD.apply(p)), e -> {
            AddonBlock m = GuiManager.openBlockChooser(p, b -> true, reopen);
            if (m != null) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.block_spawn.add_prompt", MessageReplacement.replace("%material%", m.toString()));
                GuiManager.addBlockSpawnEntry(p, mine, m);
            }
        });
        for (Map.Entry<AddonBlock, Double> entry : mine.getBlockSpawnEntries().entrySet()) {
            MessageReplacement r = MessageReplacement.replace("%precent%", String.valueOf(entry.getValue()));
            List<Component> lore = SuperMines.getInstance().getLanguageManager().getMsgComponentList((CommandSender)p, "gui.mine-management.block_spawn.each_lore", r);
            AddonBlock block = entry.getKey();
            GuiItem item = ((ItemBuilder)ItemBuilder.from((ItemStack)block.toItem()).lore(lore)).asGuiItem(e -> {
                if (!GuiManager.checkPermission(p, "supermines.block_generates")) {
                    return;
                }
                ClickType type = e.getClick();
                if (type.isLeftClick()) {
                    gui.close((HumanEntity)p);
                    SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.block_spawn.set_precent_prompt", MessageReplacement.replace("%material%", block.toString()));
                    GuiManager.addBlockSpawnEntry(p, mine, block);
                } else if (type.isRightClick()) {
                    mine.removeBlockSpawnEntry(block);
                    reopen.run();
                }
                e.setCancelled(true);
            });
            gui.addItem(item);
        }
        gui.open((HumanEntity)p);
    }

    private static void addBlockSpawnEntry(Player p, Mine mine, Material material) {
        GuiManager.addBlockSpawnEntry(p, mine, MinecraftBlockAddon.createForMaterial(material));
    }

    private static void addBlockSpawnEntry(Player p, Mine mine, AddonBlock material) {
        GuiManager.handleDoubleInput(p, 0.0, 100.0, result -> {
            mine.addBlockSpawnEntry(material, (double)result);
            GuiManager.openBlockSpawnEntries(p, mine);
        }, "gui.input.invalid-precent");
    }

    public static void openTreasureList(Player p) {
        PaginatedGui gui = GuiManager.createPaginatedGui(p, "gui.treasures.title", 45);
        GuiManager.fillPageButtons(p, gui, () -> GuiManager.openGeneral(p));
        for (Treasure treasure : SuperMines.getInstance().getTreasureManager().getAllTreasures()) {
            Material mat = Material.CHEST;
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from((Material)mat).name(treasure.getDisplayName())).lore(SuperMines.getInstance().getLanguageManager().getTreasureInfo(p, treasure))).asGuiItem(e -> {
                GuiManager.openTreasureManagementGui(p, treasure);
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
    }

    public static void openTreasureManagementGui(Player p, Treasure treasure) {
        MessageReplacement treasureName = MessageReplacement.replace("%treasure%", treasure.getRawDisplayName());
        Gui gui = GuiManager.createManagementGui(p, "gui.treasure-management.title", treasureName);
        Runnable reopen = () -> GuiManager.openTreasureManagementGui(p, treasure);
        Runnable back = () -> GuiManager.openTreasureList(p);
        GuiManager.placeCommon(p, gui, treasure, Material.CHEST, reopen, back);
        GuiManager.putItem(3, 4, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.SET_CHANCE.apply(p, treasure.getChance())), e -> {
            if (!GuiManager.checkPermission(p, "supermines.treasures")) {
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.treasure-management.set_chance.prompt", new MessageReplacement[0]);
            GuiManager.handleDoubleInput(p, 0.0, 100.0, result -> {
                treasure.setChance((double)result);
                reopen.run();
            }, "gui.input.invalid-precent");
        });
        GuiManager.putItem(3, 8, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.MATCHED_MATERIALS.apply(p)), e -> GuiManager.openMatchedMaterials(p, treasure));
        GuiManager.putTreasureItemStack((BaseGui)gui, p, treasure);
    }

    private static void putTreasureItemStack(BaseGui gui, Player p, Treasure t) {
        ItemStack clone = t.getItemStack().clone();
        ItemMeta meta = clone.getItemMeta();
        Component newName = SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.treasure-management.itemstack.name", MessageReplacement.replace("%name%", ComponentUtils.serialize(meta.displayName())));
        meta.displayName(newName);
        meta.lore(SuperMines.getInstance().getLanguageManager().getMsgComponentList((CommandSender)p, "gui.treasure-management.itemstack.lore", new MessageReplacement[0]));
        clone.setItemMeta(meta);
        GuiManager.putItem(3, 6, gui, ItemBuilder.from((ItemStack)clone), e -> {
            ItemStack item;
            if (!GuiManager.checkPermission(p, "supermines.treasures")) {
                return;
            }
            ClickType type = e.getClick();
            if (type.isRightClick()) {
                if (p.getInventory().firstEmpty() != -1) {
                    p.getInventory().addItem(new ItemStack[]{t.getItemStack()});
                }
            } else if (type.isLeftClick() && !(item = p.getItemOnCursor()).getType().isAir()) {
                t.setItemStack(item);
                GuiManager.putTreasureItemStack(gui, p, t);
            }
        });
    }

    private static void openMatchedMaterials(Player p, Treasure treasure) {
        ListGUI.openList(p, SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.treasure-management.matched_materials.title", new MessageReplacement[0]), treasure.getMatchedBlocks(), t -> {
            List<Component> lore = SuperMines.getInstance().getLanguageManager().getMsgComponentList((CommandSender)p, "gui.treasure-management.matched_materials.each_lore", new MessageReplacement[0]);
            return ((ItemBuilder)ItemBuilder.from((ItemStack)t.toItem()).lore(lore)).build();
        }, treasure::removeMatchedBlock, () -> {
            AddonBlock m = GuiManager.openBlockChooser(p, b -> true, null);
            if (!treasure.getMatchedBlocks().contains(m)) {
                treasure.addMatchedBlock(m);
            }
            GuiManager.openMatchedMaterials(p, treasure);
        }, () -> GuiManager.openTreasureManagementGui(p, treasure));
    }

    public static void openRankList(Player p) {
        PaginatedGui gui = GuiManager.createPaginatedGui(p, "gui.ranks.title", 45);
        GuiManager.fillPageButtons(p, gui, () -> GuiManager.openGeneral(p));
        for (Rank rank : SuperMines.getInstance().getRankManager().getAllRanks()) {
            Material mat = Material.NAME_TAG;
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from((Material)mat).name(rank.getDisplayName())).lore(SuperMines.getInstance().getLanguageManager().getRankInfo(p, rank))).asGuiItem(e -> {
                GuiManager.openRankManagementGui(p, rank);
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
    }

    public static void openRankManagementGui(Player p, Rank rank) {
        MessageReplacement rankName = MessageReplacement.replace("%rank%", rank.getRawDisplayName());
        Gui gui = GuiManager.createManagementGui(p, "gui.rank-management.title", rankName);
        Runnable reopen = () -> GuiManager.openRankManagementGui(p, rank);
        Runnable back = () -> GuiManager.openRankList(p);
        GuiManager.placeCommon(p, gui, rank, Material.NAME_TAG, reopen, back);
        GuiManager.putItem(3, 4, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.SET_RANK_LEVEL.apply(p, rank.getLevel())), e -> {
            if (!GuiManager.checkPermission(p, "supermines.ranks")) {
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.rank-management.setlevel.prompt", new MessageReplacement[0]);
            GuiManager.handleIntegerInput(p, result -> {
                rank.setLevel((int)result);
                reopen.run();
            });
        });
        gui.open((HumanEntity)p);
    }

    private static PaginatedGui createPaginatedGui(Player p, String titleKey, int pageSize) {
        return ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().rows(6)).pageSize(pageSize).title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, titleKey, new MessageReplacement[0]))).create();
    }

    private static Gui createManagementGui(Player p, String titleKey, MessageReplacement replacement) {
        return ((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, titleKey, replacement))).rows(6)).create();
    }

    private static boolean checkPermission(Player p, String permission) {
        if (!p.hasPermission(permission)) {
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
            return false;
        }
        return true;
    }

    private static void handleIntegerInput(Player p, Consumer<Integer> onSuccess) {
        ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
            if (result.equalsIgnoreCase(CANCEL_COMMAND)) {
                return;
            }
            try {
                int value = Integer.parseUnsignedInt(result);
                onSuccess.accept(value);
            }
            catch (NumberFormatException ex) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.input.invalid-number", new MessageReplacement[0]);
            }
        });
    }

    private static void handleDoubleInput(Player p, double min, double max, Consumer<Double> onSuccess, String errorKey) {
        ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
            if (result.equalsIgnoreCase(CANCEL_COMMAND)) {
                return;
            }
            try {
                double value = Double.parseDouble(result);
                if (value >= max || value < min) {
                    throw new NumberFormatException();
                }
                onSuccess.accept(value);
            }
            catch (NumberFormatException ex) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, errorKey, new MessageReplacement[0]);
            }
        });
    }

    private static void fillPageButtons(Player p, PaginatedGui gui, Runnable reopen) {
        gui.getFiller().fillBetweenPoints(6, 1, 6, 9, ItemBuilder.from((ItemStack)Constants.Items.BACKGROUND).asGuiItem(e -> e.setCancelled(true)));
        GuiManager.putItem(6, 1, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.CLOSE.apply(p)), e -> gui.close((HumanEntity)p));
        GuiManager.putItem(6, 3, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.PREVIOUS_PAGE.apply(p)), e -> gui.previous());
        GuiManager.putItem(6, 7, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.NEXT_PAGE.apply(p)), e -> gui.next());
        GuiManager.putItem(6, 9, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.BACK.apply(p)), e -> reopen.run());
    }

    static void putItem(int row, int col, BaseGui gui, ItemBuilder item, Consumer<InventoryClickEvent> clickEventConsumer) {
        gui.setItem(row, col, item.asGuiItem(e -> {
            clickEventConsumer.accept((InventoryClickEvent)e);
            e.setCancelled(true);
        }));
    }

    private static <T extends Identified> void placeCommon(Player p, Gui gui, T object, Material icon, Runnable reopen, Runnable back) {
        GuiFiller filler = gui.getFiller();
        filler.fillBorder(ItemBuilder.from((ItemStack)Constants.Items.BACKGROUND).asGuiItem(e -> e.setCancelled(true)));
        GuiManager.putItem(2, 5, (BaseGui)gui, (ItemBuilder)((ItemBuilder)ItemBuilder.from((Material)icon).name(object.getDisplayName())).lore(new Component[]{ComponentUtils.deserialize("&7&lID: " + object.getId())}), e -> {});
        GuiManager.putItem(3, 2, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.SET_DISPLAY_NAME.apply(p, object)), e -> {
            if (!GuiManager.checkPermission(p, "supermines.set_display_name")) {
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.set_display_name.prompt", new MessageReplacement[0]);
            ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
                if (result.equalsIgnoreCase(CANCEL_COMMAND)) {
                    return;
                }
                object.setDisplayName(ComponentUtils.deserialize(result));
                reopen.run();
            });
        });
        GuiManager.putItem(1, 9, (BaseGui)gui, ItemBuilder.from((ItemStack)Constants.Items.BACK.apply(p)), e -> back.run());
    }

    private static AddonBlock openMaterialChooser(Player p, Runnable reopen) {
        return GuiManager.openBlockChooser(p, b -> b.getKey().isBlank(), "material", reopen);
    }

    private static AddonBlock openBlockChooser(Player p, Predicate<AddonBlock> predicate, Runnable reopen) {
        return GuiManager.openBlockChooser(p, predicate, "block", reopen);
    }

    private static AddonBlock openBlockChooser(Player p, Predicate<AddonBlock> predicate, String title, Runnable reopen) {
        PaginatedGui gui = GuiManager.createPaginatedGui(p, "gui." + title + "-chooser.title", 45);
        GuiManager.fillPageButtons(p, gui, reopen);
        AtomicReference selected = new AtomicReference();
        for (AddonBlock block : BlockAddon.getAllBlocks()) {
            if (block.toItem().getType().isAir() || !predicate.test(block)) continue;
            GuiItem guiItem = ItemBuilder.from((ItemStack)block.toItem()).asGuiItem(e -> {
                selected.set(block);
                reopen.run();
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
        return (AddonBlock)selected.get();
    }
}

