/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.pos;

import io.github.lijinhong11.supermines.api.pos.BlockPos;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public record CuboidArea(BlockPos pos1, BlockPos pos2) {
    public static CuboidArea createFromLocation(Location loc1, Location loc2) {
        return new CuboidArea(BlockPos.fromLocation(loc1), BlockPos.fromLocation(loc2));
    }

    public BlockPos getMin() {
        return new BlockPos(Math.min(this.pos1.x(), this.pos2.x()), Math.min(this.pos1.y(), this.pos2.y()), Math.min(this.pos1.z(), this.pos2.z()));
    }

    public BlockPos getMax() {
        return new BlockPos(Math.max(this.pos1.x(), this.pos2.x()), Math.max(this.pos1.y(), this.pos2.y()), Math.max(this.pos1.z(), this.pos2.z()));
    }

    public Location getCenterLocation(World world) {
        BlockPos min = this.getMin();
        BlockPos max = this.getMax();
        double centerX = (double)(min.x() + max.x()) / 2.0 + 0.5;
        double centerZ = (double)(min.z() + max.z()) / 2.0 + 0.5;
        return new Location(world, centerX, (double)(Math.max(this.pos1.y(), this.pos2.y()) + 1), centerZ);
    }

    public CuboidArea expand(int x) {
        return this.expand(x, 0);
    }

    public CuboidArea expand(int x, int y) {
        return this.expand(x, y, 0);
    }

    public CuboidArea expand(int x, int y, int z) {
        return new CuboidArea(this.pos1.minus(x, y, z), this.pos2.plus(x, y, z));
    }

    public boolean contains(BlockPos pos) {
        BlockPos min = this.getMin();
        BlockPos max = this.getMax();
        return pos.x() >= min.x() && pos.x() <= max.x() && pos.y() >= min.y() && pos.y() <= max.y() && pos.z() >= min.z() && pos.z() <= max.z();
    }

    public int sizeX() {
        return Math.abs(this.pos1.x() - this.pos2.x()) + 1;
    }

    public int sizeY() {
        return Math.abs(this.pos1.y() - this.pos2.y()) + 1;
    }

    public int sizeZ() {
        return Math.abs(this.pos1.z() - this.pos2.z()) + 1;
    }

    public int volume() {
        return this.sizeX() * this.sizeY() * this.sizeZ();
    }

    public void forEach(Consumer<BlockPos> action) {
        BlockPos min = this.getMin();
        BlockPos max = this.getMax();
        for (int x = min.x(); x <= max.x(); ++x) {
            for (int y = min.y(); y <= max.y(); ++y) {
                for (int z = min.z(); z <= max.z(); ++z) {
                    action.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    public List<BlockPos> asPosList() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.volume());
        this.forEach(list::add);
        return list;
    }

    @Override
    @NotNull
    public String toString() {
        return "CuboidArea{" + String.valueOf(this.getMin()) + " -> " + String.valueOf(this.getMax()) + "}";
    }
}

