/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.mine;

import com.google.common.base.Preconditions;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.integrates.block.AddonBlock;
import io.github.lijinhong11.supermines.integrates.block.MinecraftBlockAddon;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class Treasure
implements Identified {
    private final Set<AddonBlock> matchedMaterials;
    private final String id;
    private Component displayName;
    private ItemStack itemStack;
    private double chance;

    @ParametersAreNonnullByDefault
    public Treasure(String id, Component displayName, ItemStack itemStack, double chance) {
        this(id, displayName, itemStack, chance, Set.of());
    }

    @ParametersAreNonnullByDefault
    public Treasure(String id, Component displayName, ItemStack itemStack, double chance, Set<AddonBlock> matchedMaterials) {
        this.id = id;
        this.displayName = displayName;
        this.itemStack = itemStack;
        this.chance = chance;
        this.matchedMaterials = matchedMaterials;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRawDisplayName() {
        if (this.displayName == null) {
            return this.id;
        }
        return ComponentUtils.serialize(this.displayName);
    }

    @Override
    public Component getDisplayName() {
        return this.displayName == null ? ComponentUtils.text(this.id) : this.displayName;
    }

    @Override
    public void setDisplayName(@Nullable Component displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"display name cannot be null");
        this.displayName = displayName;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    public void addMatchedMaterial(Material material) {
        this.addMatchedBlock(MinecraftBlockAddon.createForMaterial(material));
    }

    public void addMatchedBlock(AddonBlock block) {
        this.matchedMaterials.add(block);
    }

    public void removeMatchedMaterial(Material material) {
        this.matchedMaterials.remove(MinecraftBlockAddon.createForMaterial(material));
    }

    public void removeMatchedBlock(AddonBlock block) {
        this.matchedMaterials.remove(block);
    }

    public Set<AddonBlock> getMatchedBlocks() {
        return this.matchedMaterials;
    }
}

