/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.data.PlayerData;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperMinesAPI {
    private SuperMinesAPI() {
        throw new IllegalStateException();
    }

    @Nullable
    public static Mine getMine(String id) {
        return SuperMines.getInstance().getMineManager().getMine(id);
    }

    @Nullable
    public static Mine getMine(Location loc) {
        return SuperMines.getInstance().getMineManager().getMine(loc);
    }

    @NotNull
    public static Collection<Mine> getMines() {
        return SuperMines.getInstance().getMineManager().getAllMines();
    }

    @Nullable
    public static Treasure getTreasure(String id) {
        return SuperMines.getInstance().getTreasureManager().getTreasure(id);
    }

    @NotNull
    public static Collection<Treasure> getTreasures() {
        return SuperMines.getInstance().getTreasureManager().getAllTreasures();
    }

    @Nullable
    public static Rank getRank(String id) {
        return SuperMines.getInstance().getRankManager().getRank(id);
    }

    @NotNull
    public static Collection<Rank> getRanks() {
        return SuperMines.getInstance().getRankManager().getAllRanks();
    }

    @Nullable
    public static PlayerData getPlayerData(@NotNull String name) {
        return SuperMines.getInstance().getPlayerDataManager().getPlayerData(name);
    }

    @NotNull
    public static PlayerData getOrCreatePlayerData(@NotNull UUID playerUUID) {
        return SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(playerUUID);
    }

    public static void addMine(@NotNull Mine mine) {
        SuperMines.getInstance().getMineManager().addMine(mine);
    }

    public static void removeMine(@NotNull String id) {
        SuperMines.getInstance().getMineManager().removeMine(id);
    }

    public static void addTreasure(@NotNull Treasure treasure) {
        SuperMines.getInstance().getTreasureManager().addTreasure(treasure);
    }

    public static void removeTreasure(@NotNull String id) {
        SuperMines.getInstance().getTreasureManager().removeTreasure(id);
    }

    public static void addRank(@NotNull Rank rank) {
        SuperMines.getInstance().getRankManager().addRank(rank);
    }

    public static void removeRank(@NotNull String id) {
        SuperMines.getInstance().getRankManager().removeRank(id);
    }
}

