/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.utils;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConfigurationOptions;
import org.bukkit.plugin.Plugin;

public class ConfigFileUtil {
    private ConfigFileUtil() {
    }

    public static void completeFile(Plugin plugin, String resourceFile) {
        if (plugin == null) {
            return;
        }
        InputStream stream = plugin.getResource(resourceFile);
        File file = new File(plugin.getDataFolder(), resourceFile);
        if (!resourceFile.endsWith("yml")) {
            return;
        }
        if (resourceFile.contains("../")) {
            return;
        }
        if (ConfigFileUtil.fileCheck(plugin, resourceFile, stream, file)) {
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((Reader)reader);
            YamlConfiguration configuration2 = YamlConfiguration.loadConfiguration((File)file);
            for (String key : configuration.getKeys(true)) {
                ConfigFileUtil.complete0(configuration, configuration2, key);
                YamlConfigurationOptions options1 = configuration.options();
                YamlConfigurationOptions options2 = configuration2.options();
                if (options2.getHeader().equals(options1.getHeader())) continue;
                options2.setHeader(options1.getHeader());
            }
            configuration2.save(file);
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.WARNING, "File completion of '" + resourceFile + "' is failed.", e);
        }
    }

    private static void complete0(YamlConfiguration configuration, YamlConfiguration configuration2, String key) {
        List list2;
        Object value = configuration.get(key);
        if (value instanceof List && (list2 = configuration2.getList(key)) == null) {
            configuration2.set(key, value);
        }
        if (!configuration2.contains(key)) {
            configuration2.set(key, value);
        }
        if (!configuration.getComments(key).equals(configuration2.getComments(key))) {
            configuration2.setComments(key, configuration.getComments(key));
        }
    }

    public static void completeLangFile(Plugin plugin, String resourceFile) {
        InputStream stream = plugin.getResource(resourceFile);
        if (!resourceFile.endsWith("yml")) {
            return;
        }
        if (resourceFile.contains("../")) {
            return;
        }
        File file = new File(plugin.getDataFolder(), resourceFile);
        if (ConfigFileUtil.fileCheck(plugin, resourceFile, stream, file)) {
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((Reader)reader);
            YamlConfiguration configuration2 = YamlConfiguration.loadConfiguration((File)file);
            Set keys = configuration.getKeys(true);
            for (String key : keys) {
                ConfigFileUtil.complete0(configuration, configuration2, key);
                if (!(configuration2.contains(key) & !configuration.contains(key))) continue;
                configuration2.set(key, null);
            }
            configuration2.save(file);
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.WARNING, "File completion of '" + resourceFile + "' is failed.", e);
        }
    }

    private static boolean fileCheck(Plugin plugin, String resourceFile, InputStream stream, File file) {
        if (!file.getAbsolutePath().startsWith(plugin.getDataFolder().getAbsolutePath())) {
            return true;
        }
        if (!file.exists()) {
            if (stream != null) {
                plugin.saveResource(resourceFile, false);
                return true;
            }
            plugin.getLogger().warning("File completion of '" + resourceFile + "' is failed.");
            return true;
        }
        if (stream == null) {
            plugin.getLogger().warning("File completion of '" + resourceFile + "' is failed.");
            return true;
        }
        return false;
    }
}

