/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.task;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.api.pos.BlockPos;
import io.github.lijinhong11.supermines.api.pos.CuboidArea;
import io.github.lijinhong11.supermines.libraries.folialib.wrapper.task.WrappedTask;
import io.github.lijinhong11.supermines.message.MessageReplacement;
import io.github.lijinhong11.supermines.task.AbstractTask;
import io.github.lijinhong11.supermines.task.TaskMaker;
import io.github.lijinhong11.supermines.utils.NumberUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class MineResetTask
extends AbstractTask {
    private final Mine mine;
    private final AtomicLong nextResetTime = new AtomicLong();

    MineResetTask(Mine mine) {
        this.mine = mine;
        this.refreshNextResetTime();
    }

    public long getNextResetTime() {
        return this.nextResetTime.get();
    }

    @Override
    public void run(WrappedTask wrappedTask) {
        this.refreshNextResetTime();
        this.doReset();
    }

    private void doReset() {
        Location loc;
        CuboidArea ca = this.mine.getArea();
        List<BlockPos> blockPosList = ca.asPosList();
        Map<Material, Double> blockSpawnEntries = this.mine.getBlockSpawnEntries();
        HashMap<BlockPos, Material> generated = new HashMap<BlockPos, Material>();
        if (blockSpawnEntries.isEmpty()) {
            return;
        }
        for (BlockPos pos : blockPosList) {
            Location location = pos.toLocation(this.mine.getWorld());
            Material material = location.getBlock().getType();
            if (this.mine.isOnlyFillAirWhenRegenerate() && !material.isAir()) continue;
            Material selected = null;
            for (Map.Entry<Material, Double> entry : blockSpawnEntries.entrySet()) {
                if (!NumberUtils.matchChance(entry.getValue())) continue;
                selected = entry.getKey();
                break;
            }
            if (selected == null && !blockSpawnEntries.isEmpty()) {
                selected = NumberUtils.weightedRandom(blockSpawnEntries);
            }
            generated.put(pos, selected);
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (this.mine.getTeleportLocation() != null && this.mine.isPlayerInMine(p)) {
                p.teleportAsync(this.mine.getTeleportLocation());
            }
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "mine.reset", MessageReplacement.replace("%mine%", this.mine.getRawDisplayName()));
        }
        TaskMaker tm = SuperMines.getInstance().getTaskMaker();
        if (!this.mine.isOnlyFillAirWhenRegenerate()) {
            for (BlockPos blockPos : blockPosList) {
                loc = blockPos.toLocation(this.mine.getWorld());
                tm.runSync(loc, () -> loc.getBlock().setType(Material.AIR));
            }
        }
        for (Map.Entry entry : generated.entrySet()) {
            loc = ((BlockPos)entry.getKey()).toLocation(this.mine.getWorld());
            tm.runSync(loc, () -> loc.getBlock().setType((Material)entry.getValue()));
        }
        this.mine.setBlocksBroken(0);
    }

    public void refreshNextResetTime() {
        this.nextResetTime.set(System.currentTimeMillis() + (long)this.mine.getRegenerateSeconds() * 1000L);
    }
}

