/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.managers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.managers.abstracts.AbstractFileObjectManager;
import io.github.lijinhong11.supermines.utils.ItemUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreasureManager
extends AbstractFileObjectManager<Treasure> {
    private final Map<String, Treasure> treasures = new HashMap<String, Treasure>();

    public TreasureManager() {
        super("data/treasures.yml");
        this.load();
    }

    private void load() {
        for (Treasure object : super.getAll()) {
            this.treasures.put(object.getId(), object);
        }
    }

    @Override
    protected Treasure getObject(@NotNull ConfigurationSection section) {
        String id = section.getCurrentPath();
        if (id == null) {
            return null;
        }
        double chance = section.getDouble("chance");
        if (chance <= 0.0 || chance > 100.0) {
            chance = 1.0;
            section.set("chance", (Object)1);
        }
        return new Treasure(id, MiniMessage.miniMessage().deserialize((Object)section.getString("displayName", id)), ItemUtils.deserializeFromBytes((byte[])section.getObject("itemStack", byte[].class)), chance, section.getStringList("matchedMaterials").stream().map(Material::getMaterial).collect(Collectors.toSet()));
    }

    @Override
    protected void putObject(@NotNull ConfigurationSection section, Treasure object) {
        section.set("id", (Object)object.getId());
        section.set("displayName", MiniMessage.miniMessage().serialize(object.getDisplayName()));
        section.set("itemStack", (Object)ItemUtils.serializeToBytes(object.getItemStack()));
        section.set("chance", (Object)object.getChance());
        section.set("matchedMaterials", object.getMatchedMaterials().stream().map(Enum::toString).toList());
    }

    @Override
    public void saveAndClose() {
        for (Treasure treasure : this.treasures.values()) {
            super.putObject(treasure.getId(), treasure);
        }
    }

    public void addTreasure(Treasure treasure) {
        Preconditions.checkNotNull((Object)treasure, (Object)"treasure cannot be null");
        if (this.treasures.containsKey(treasure.getId())) {
            throw new IllegalArgumentException("treasure with ID " + treasure.getId() + " already exists");
        }
        this.treasures.put(treasure.getId(), treasure);
        super.putObject(treasure.getId(), treasure);
    }

    @Nullable
    public Treasure getTreasure(@NotNull String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"treasure id cannot be null or empty");
        return this.treasures.get(id);
    }

    public void removeTreasure(@NotNull String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"treasure id cannot be null or empty");
        this.treasures.remove(key);
        super.remove(key);
    }

    public Collection<Treasure> getAllTreasures() {
        return this.treasures.values();
    }

    public Set<String> getAllTreasureIds() {
        return this.treasures.keySet();
    }
}

