/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.sql.sentence;

import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.enums.JoinType;
import io.github.lijinhong11.supermines.libraries.database.enums.OrderType;
import io.github.lijinhong11.supermines.libraries.database.sql.conditions.Condition;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SelectSQL
extends SQL {
    private boolean distinct = false;
    private final List<String> columns = new ArrayList<String>();
    private String table;
    private final List<JoinClause> joins = new ArrayList<JoinClause>();
    private Condition whereCondition;
    private final List<GroupBy> groupByList = new ArrayList<GroupBy>();
    private Condition havingCondition;
    private final List<OrderBy> orderByList = new ArrayList<OrderBy>();
    private Integer limit;
    private Integer offset;
    private boolean forUpdate = false;
    private final List<Object> parameters = new ArrayList<Object>();

    SelectSQL() {
    }

    public SelectSQL distinct() {
        this.distinct = true;
        return this;
    }

    public SelectSQL from(String table) {
        this.validateIdentifier(table);
        this.table = table;
        return this;
    }

    public SelectSQL column(String column) {
        this.validateIdentifier(column);
        this.columns.add(column);
        return this;
    }

    public SelectSQL column(String column, String alias) {
        this.validateIdentifier(column);
        if (alias != null) {
            this.validateIdentifier(alias);
        }
        this.columns.add(column + (String)(alias != null ? " AS " + alias : ""));
        return this;
    }

    public SelectSQL columns(String ... columns) {
        for (String column : columns) {
            this.column(column);
        }
        return this;
    }

    public SelectSQL allColumns() {
        this.columns.add("*");
        return this;
    }

    public SelectSQL join(String table, String onClause) {
        return this.join(table, onClause, JoinType.INNER);
    }

    public SelectSQL join(String table, String onClause, JoinType joinType) {
        this.validateIdentifier(table);
        this.joins.add(new JoinClause(table, onClause, joinType));
        return this;
    }

    public SelectSQL leftJoin(String table, String onClause) {
        return this.join(table, onClause, JoinType.LEFT);
    }

    public SelectSQL rightJoin(String table, String onClause) {
        return this.join(table, onClause, JoinType.RIGHT);
    }

    public SelectSQL fullJoin(String table, String onClause) {
        return this.join(table, onClause, JoinType.FULL);
    }

    public SelectSQL where(Condition condition) {
        this.whereCondition = condition;
        return this;
    }

    public SelectSQL groupBy(String column) {
        this.validateIdentifier(column);
        this.groupByList.add(new GroupBy(column));
        return this;
    }

    public SelectSQL groupBy(String column, String ... additionalColumns) {
        this.groupBy(column);
        for (String col : additionalColumns) {
            this.groupBy(col);
        }
        return this;
    }

    public SelectSQL having(Condition condition) {
        this.havingCondition = condition;
        return this;
    }

    public SelectSQL orderBy(String column) {
        return this.orderBy(column, OrderType.ASC);
    }

    public SelectSQL orderBy(String column, OrderType orderType) {
        this.validateIdentifier(column);
        this.orderByList.add(new OrderBy(column, orderType));
        return this;
    }

    public SelectSQL limit(int limit) {
        this.limit = limit;
        return this;
    }

    public SelectSQL offset(int offset) {
        this.offset = offset;
        return this;
    }

    public SelectSQL forUpdate() {
        this.forUpdate = true;
        return this;
    }

    @Override
    public String getSql(DatabaseType type) {
        if (this.table == null) {
            throw new IllegalStateException("Table must be specified");
        }
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("At least one column must be selected");
        }
        this.parameters.clear();
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.distinct) {
            sql.append("DISTINCT ");
        }
        sql.append(String.join((CharSequence)", ", this.columns));
        sql.append(" FROM ").append(this.table);
        for (JoinClause join : this.joins) {
            sql.append(" ").append(join.joinType.getSql()).append(" JOIN ").append(join.table).append(" ON ").append(join.onClause);
        }
        if (this.whereCondition != null) {
            sql.append(" WHERE ").append(this.whereCondition.getSql());
            this.parameters.addAll(this.whereCondition.getParameters());
        }
        if (!this.groupByList.isEmpty()) {
            sql.append(" GROUP BY ").append(this.groupByList.stream().map(GroupBy::column).collect(Collectors.joining(", ")));
        }
        if (this.havingCondition != null) {
            sql.append(" HAVING ").append(this.havingCondition.getSql());
            this.parameters.addAll(this.havingCondition.getParameters());
        }
        if (!this.orderByList.isEmpty()) {
            sql.append(" ORDER BY ").append(this.orderByList.stream().map(ob -> ob.column + " " + String.valueOf((Object)ob.orderType)).collect(Collectors.joining(", ")));
        }
        if (this.limit != null) {
            sql.append(" LIMIT ?");
            this.parameters.add(this.limit);
        }
        if (this.offset != null) {
            sql.append(" OFFSET ?");
            this.parameters.add(this.offset);
        }
        if (this.forUpdate) {
            sql.append(" FOR UPDATE");
        }
        return sql.toString();
    }

    @Override
    public PreparedStatement build(Connection connection, DatabaseType type) throws SQLException {
        String sql = this.getSql(type);
        PreparedStatement stmt = connection.prepareStatement(sql);
        for (int i = 0; i < this.parameters.size(); ++i) {
            stmt.setObject(i + 1, this.parameters.get(i));
        }
        return stmt;
    }

    @Override
    protected void validateIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Identifier cannot be null or empty");
        }
        if (!identifier.matches("[a-zA-Z_][a-zA-Z0-9_]*") && !identifier.equals("*")) {
            throw new IllegalArgumentException("Invalid SQL identifier: " + identifier);
        }
    }

    private record JoinClause(String table, String onClause, JoinType joinType) {
    }

    private record GroupBy(String column) {
    }

    private record OrderBy(String column, OrderType orderType) {
    }
}

