/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.serialization;

import io.github.lijinhong11.supermines.libraries.database.serialization.ObjectConverter;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Column;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Converter;
import io.github.lijinhong11.supermines.libraries.database.serialization.converters.UUIDConverter;
import io.github.lijinhong11.supermines.libraries.database.serialization.exceptions.CannotInstanceException;
import io.github.lijinhong11.supermines.libraries.database.serialization.exceptions.SerializationException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class ObjectSerializer {
    private static final Map<Class<?>, ObjectConverter<?>> CONVERTERS = new ConcurrentHashMap();
    private static final Map<Class<?>, List<Field>> FIELD_CACHE = new ConcurrentHashMap();

    private ObjectSerializer() {
    }

    public static <T> void registerConverter(Class<T> clazz, ObjectConverter<T> converter) {
        CONVERTERS.put(clazz, converter);
    }

    public static <T> T serializeOne(Class<T> clazz, ResultSet set) {
        try {
            T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : ObjectSerializer.getCachedFields(clazz)) {
                try {
                    ObjectSerializer.setFieldValue(obj, field, set);
                }
                catch (SQLException e) {
                    if (!ObjectSerializer.isColumnExists(set, ObjectSerializer.getColumnName(field))) continue;
                    throw new SerializationException("Failed to set field " + field.getName(), e);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new CannotInstanceException(clazz, (Throwable)e);
        }
    }

    public static <T> List<T> serializeMulti(Class<T> clazz, ResultSet set) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            while (set.next()) {
                list.add(ObjectSerializer.serializeOne(clazz, set));
            }
        }
        catch (SQLException e) {
            throw new SerializationException("Failed to serialize multiple objects", e);
        }
        return list;
    }

    public static Object convertBack(Object obj) {
        if (obj == null) {
            return null;
        }
        return ObjectSerializer.convertBack(obj, obj.getClass());
    }

    public static Object convertBack(Object obj, Class<?> clazz) {
        if (obj == null) {
            return null;
        }
        if (clazz.isEnum()) {
            return obj.toString();
        }
        if (CONVERTERS.containsKey(clazz)) {
            return CONVERTERS.get(clazz).convertBack(obj);
        }
        return obj;
    }

    private static <T> List<Field> getCachedFields(Class<T> clazz) {
        if (FIELD_CACHE.containsKey(clazz)) {
            return FIELD_CACHE.get(clazz);
        }
        List<Field> fields = ObjectSerializer.getAllFields(clazz);
        FIELD_CACHE.put(clazz, fields);
        return fields;
    }

    private static boolean isColumnExists(ResultSet set, String columnName) {
        try {
            return set.findColumn(columnName) > 0;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private static <T> void setFieldValue(T obj, Field field, ResultSet set) throws SQLException, IllegalAccessException {
        String columnName = ObjectSerializer.getColumnName(field);
        Object value = ObjectSerializer.getValueFromResultSet(set, columnName, field.getType());
        if (value != null) {
            field.set(obj, value);
        }
    }

    @Nullable
    public static String getColumnName(Field field) {
        Column column;
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)) != null) {
            if (column.name().equals("AUTO_FOLLOW_FIELD_NAME")) {
                return field.getName();
            }
            return column.name();
        }
        return null;
    }

    private static Object getValueFromResultSet(ResultSet set, String columnName, Class<?> type) throws SQLException {
        if (type == String.class) {
            return set.getString(columnName);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return set.getInt(columnName);
        }
        if (type == Long.TYPE || type == Long.class) {
            return set.getLong(columnName);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return set.getBoolean(columnName);
        }
        if (type == Double.TYPE || type == Double.class) {
            return set.getDouble(columnName);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(set.getFloat(columnName));
        }
        if (type == Date.class) {
            return set.getDate(columnName);
        }
        if (type == Timestamp.class) {
            return set.getTimestamp(columnName);
        }
        if (type == Time.class) {
            return set.getTime(columnName);
        }
        if (type == BigDecimal.class) {
            return set.getBigDecimal(columnName);
        }
        if (type == Blob.class) {
            return set.getBlob(columnName);
        }
        if (type == Clob.class) {
            return set.getClob(columnName);
        }
        if (type == NClob.class) {
            return set.getNClob(columnName);
        }
        if (type == byte[].class) {
            return set.getBytes(columnName);
        }
        if (type.isEnum()) {
            String value = set.getString(columnName);
            return value != null ? Enum.valueOf(type, value) : null;
        }
        ObjectConverter<?> converter = CONVERTERS.get(type);
        if (converter != null) {
            return converter.convert(set.getObject(columnName));
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getName());
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            if (field.isAnnotationPresent(Converter.class)) {
                try {
                    CONVERTERS.put(field.getType(), field.getAnnotation(Converter.class).value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            field.setAccessible(true);
            fields.add(field);
        }
        return fields;
    }

    public static String getSqlType(Class<?> javaType) {
        if (javaType == String.class) {
            return "TEXT";
        }
        if (javaType == Integer.TYPE || javaType == Integer.class) {
            return "INTEGER";
        }
        if (javaType == Long.TYPE || javaType == Long.class) {
            return "BIGINT";
        }
        if (javaType == Boolean.TYPE || javaType == Boolean.class) {
            return "BOOLEAN";
        }
        if (javaType == Double.TYPE || javaType == Double.class) {
            return "DOUBLE";
        }
        if (javaType == Float.TYPE || javaType == Float.class) {
            return "FLOAT";
        }
        if (javaType == Date.class || javaType == Timestamp.class) {
            return "DATETIME";
        }
        if (javaType == BigDecimal.class) {
            return "DECIMAL(18,6)";
        }
        if (javaType.isEnum()) {
            return "VARCHAR(100)";
        }
        if (javaType.isArray()) {
            return "BLOB";
        }
        ObjectConverter<?> converter = CONVERTERS.get(javaType);
        if (converter != null) {
            return converter.getSqlType();
        }
        throw new IllegalArgumentException("Unsupported type: " + javaType.getName());
    }

    static {
        ObjectSerializer.registerConverter(UUID.class, new UUIDConverter());
    }
}

