/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.credential.env;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.Configuration;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.HostAddress;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Credential;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.CredentialPlugin;

public class EnvCredentialPlugin
implements CredentialPlugin {
    private Configuration conf;
    private String userName;

    @Override
    public String type() {
        return "ENV";
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) {
        this.conf = conf;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.conf.nonMappedOptions().getProperty("userKey");
        String pwdKey = this.conf.nonMappedOptions().getProperty("pwdKey");
        String envUser = System.getenv(userKey != null ? userKey : "MARIADB_USER");
        return new Credential(envUser == null ? this.userName : envUser, System.getenv(pwdKey != null ? pwdKey : "MARIADB_PWD"));
    }
}

