/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ColumnDecoder;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.DataType;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.MutableInt;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.UUID;

public class UuidCodec
implements Codec<UUID> {
    public static final UuidCodec INSTANCE = new UuidCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, DataType.VARSTRING, DataType.STRING);

    @Override
    public String className() {
        return UUID.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(UUID.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof UUID;
    }

    @Override
    public UUID decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return UUID.fromString(column.decodeStringText(buf, length, cal, context));
    }

    @Override
    public UUID decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return UUID.fromString(column.decodeStringBinary(buf, length, cal, context));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeByte(39);
        encoder.writeAscii(value.toString());
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer writer, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        String valueSt = value.toString();
        writer.writeLength(valueSt.length());
        writer.writeAscii(valueSt);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARSTRING.get();
    }
}

