/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ColumnDecoder;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.DataType;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.MutableInt;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Codec;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.Geometry;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.MultiPoint;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.Point;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;

public class MultiPointCodec
implements Codec<MultiPoint> {
    public static final MultiPointCodec INSTANCE = new MultiPointCodec();

    @Override
    public String className() {
        return MultiPoint.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(MultiPoint.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof MultiPoint;
    }

    @Override
    public MultiPoint decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal, context);
    }

    @Override
    public MultiPoint decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length.get() - 4, column);
            if (geo instanceof MultiPoint) {
                return (MultiPoint)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as MultiPoint", geo.getClass().getName()));
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as MultiPoint", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_MPointFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        MultiPoint mp = (MultiPoint)value;
        encoder.writeLength(13L + (long)mp.getPoints().length * 21L);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(4);
        encoder.writeInt(mp.getPoints().length);
        for (Point pt : mp.getPoints()) {
            encoder.writeByte(1);
            encoder.writeInt(1);
            encoder.writeDouble(pt.getX());
            encoder.writeDouble(pt.getY());
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

