/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ColumnDecoder;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.DataType;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.MutableInt;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Codec;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.Geometry;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.LineString;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.type.Point;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;

public class LineStringCodec
implements Codec<LineString> {
    public static final LineStringCodec INSTANCE = new LineStringCodec();

    @Override
    public String className() {
        return LineString.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(LineString.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LineString;
    }

    @Override
    public LineString decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal, context);
    }

    @Override
    public LineString decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length.get() - 4, column);
            if (geo instanceof LineString) {
                return (LineString)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as LineString", geo.getClass().getName()));
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as LineString", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_LineFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        LineString line = (LineString)value;
        encoder.writeLength(13L + (long)line.getPoints().length * 16L);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(2);
        encoder.writeInt(line.getPoints().length);
        for (Point pt : line.getPoints()) {
            encoder.writeDouble(pt.getX());
            encoder.writeDouble(pt.getY());
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

