/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ColumnDecoder;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.DataType;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.MutableInt;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;

public class DateCodec
implements Codec<java.sql.Date> {
    public static final DateCodec INSTANCE = new DateCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATE, new DataType[]{DataType.NEWDATE, DataType.DATETIME, DataType.TIMESTAMP, DataType.YEAR, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return java.sql.Date.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(java.sql.Date.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof java.sql.Date;
    }

    @Override
    public java.sql.Date decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return column.decodeDateText(buf, length, cal, context);
    }

    @Override
    public java.sql.Date decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return column.decodeDateBinary(buf, length, cal, context);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Calendar cal = providedCal == null ? context.getDefaultCalendar() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(val);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        encoder.writeByte(39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar providedCal, Long maxLength) throws IOException {
        if (providedCal == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTimeInMillis(((Date)value).getTime());
            encoder.writeByte(4);
            encoder.writeShort((short)cal.get(1));
            encoder.writeByte(cal.get(2) + 1 & 0xFF);
            encoder.writeByte(cal.get(5) & 0xFF);
        } else {
            Calendar calendar = providedCal;
            synchronized (calendar) {
                providedCal.clear();
                providedCal.setTimeInMillis(((Date)value).getTime());
                encoder.writeByte(4);
                encoder.writeShort((short)providedCal.get(1));
                encoder.writeByte(providedCal.get(2) + 1 & 0xFF);
                encoder.writeByte(providedCal.get(5) & 0xFF);
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATE.get();
    }
}

