/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.authentication.standard;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Reader;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.AuthSwitchPacket;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.AuthenticationPlugin;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.Credential;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class NativePasswordPlugin
implements AuthenticationPlugin {
    private String authenticationData;
    private byte[] seed;

    public static byte[] encryptPassword(CharSequence password, byte[] seed) {
        try {
            if (password == null) {
                return new byte[0];
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] bytePwd = password.toString().getBytes(StandardCharsets.UTF_8);
            byte[] stage1 = messageDigest.digest(bytePwd);
            messageDigest.reset();
            byte[] stage2 = messageDigest.digest(stage1);
            messageDigest.reset();
            messageDigest.update(seed);
            messageDigest.update(stage2);
            byte[] digest = messageDigest.digest();
            byte[] returnBytes = new byte[digest.length];
            for (int i = 0; i < digest.length; ++i) {
                returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
            }
            return returnBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not use SHA-1, failing", e);
        }
    }

    public NativePasswordPlugin(String authenticationData, byte[] seed) {
        this.seed = seed;
        this.authenticationData = authenticationData;
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context) throws IOException {
        if (this.authenticationData == null) {
            out.writeEmptyPacket();
        } else {
            byte[] truncatedSeed = AuthSwitchPacket.getTruncatedSeed(this.seed);
            out.writeBytes(NativePasswordPlugin.encryptPassword(this.authenticationData, truncatedSeed));
            out.flush();
        }
        return in.readReusablePacket();
    }

    @Override
    public boolean isMitMProof() {
        return true;
    }

    @Override
    public byte[] hash(Credential credential) {
        try {
            MessageDigest messageDigestSHA1 = MessageDigest.getInstance("SHA-1");
            byte[] bytePwd = credential.getPassword().getBytes(StandardCharsets.UTF_8);
            byte[] stage1 = messageDigestSHA1.digest(bytePwd);
            messageDigestSHA1.reset();
            byte[] stage2 = messageDigestSHA1.digest(stage1);
            messageDigestSHA1.reset();
            return stage2;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not use SHA-1, failing", e);
        }
    }
}

