/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.ServerPreparedStatement;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Context;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.socket.Writer;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.Parameter;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.Parameters;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.export.Prepare;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.ClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client.LongDataPacket;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client.RedoableWithPrepareClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.PrepareResultPacket;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.plugin.codec.ByteArrayCodec;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class ExecutePacket
implements RedoableWithPrepareClientMessage {
    private final String command;
    private final ServerPreparedStatement prep;
    private final InputStream localInfileInputStream;
    private Prepare prepareResult;
    private Parameters parameters;

    public ExecutePacket(Prepare prepareResult, Parameters parameters, String command, ServerPreparedStatement prep, InputStream localInfileInputStream) {
        this.parameters = parameters;
        this.prepareResult = prepareResult;
        this.command = command;
        this.prep = prep;
        this.localInfileInputStream = localInfileInputStream;
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            this.parameters.set(i, new io.github.lijinhong11.supermines.libraries.database.libs.mariadb.codec.Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
        }
    }

    @Override
    public int encode(Writer writer, Context context, Prepare newPrepareResult) throws IOException, SQLException {
        int statementId = newPrepareResult != null && newPrepareResult.getStatementId() != -1 ? newPrepareResult.getStatementId() : (this.prepareResult != null ? this.prepareResult.getStatementId() : -1);
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            Parameter p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            new LongDataPacket(statementId, p, i).encode(writer, context);
        }
        writer.initPacket();
        writer.writeByte(23);
        writer.writeInt(statementId);
        writer.writeByte(0);
        writer.writeInt(1);
        if (parameterCount > 0) {
            Parameter p;
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            int initialPos = writer.pos();
            writer.pos(initialPos + nullCount);
            writer.writeByte(1);
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                writer.writeByte(p.getBinaryEncodeType());
                writer.writeByte(0);
                if (!p.isNull()) continue;
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | (byte)(1 << i % 8));
            }
            writer.writeBytesAtPos(nullBitsBuffer, initialPos);
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                if (p.isNull() || p.canEncodeLongData()) continue;
                p.encodeBinary(writer, context);
            }
        }
        writer.flush();
        return 1;
    }

    @Override
    public boolean canSkipMeta() {
        return true;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public ServerPreparedStatement prep() {
        return this.prep;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String description() {
        return "EXECUTE " + this.command;
    }

    @Override
    public boolean validateLocalFileName(String fileName, Context context) {
        return ClientMessage.validateLocalFileName(this.command, this.parameters, fileName, context);
    }

    @Override
    public void setPrepareResult(PrepareResultPacket prepareResult) {
        this.prepareResult = prepareResult;
    }
}

