/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.impl;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.Configuration;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.HostAddress;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.Statement;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.Completion;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.context.RedoContext;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.impl.StandardClient;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.impl.TransactionSaver;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.util.ClosableLock;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.export.MaxAllowedPacketException;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.export.Prepare;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.ClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client.PreparePacket;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client.RedoableClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.client.RedoableWithPrepareClientMessage;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.message.server.PrepareResultPacket;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.util.log.Logger;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.util.log.Loggers;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class ReplayClient
extends StandardClient {
    private static final Logger logger = Loggers.getLogger(ReplayClient.class);

    public ReplayClient(Configuration conf, HostAddress hostAddress, ClosableLock lock, boolean skipPostCommands) throws SQLException {
        super(conf, hostAddress, lock, skipPostCommands);
    }

    @Override
    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            if (message instanceof RedoableClientMessage) {
                ((RedoableClientMessage)message).ensureReplayable(this.context);
            }
            return message.encode(this.writer, this.context);
        }
        catch (MaxAllowedPacketException maxE) {
            if (maxE.isMustReconnect()) {
                this.destroySocket();
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", maxE);
            }
            throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", maxE);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> res = super.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(messages);
        return res;
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> completions = super.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(message);
        return completions;
    }

    public void transactionReplay(TransactionSaver transactionSaver) throws SQLException {
        RedoableClientMessage[] buffers = transactionSaver.getBuffers();
        try {
            for (int i = 0; i < transactionSaver.getIdx(); ++i) {
                int responseNo;
                RedoableClientMessage querySaver = buffers[i];
                if (querySaver instanceof RedoableWithPrepareClientMessage) {
                    RedoableWithPrepareClientMessage redoable = (RedoableWithPrepareClientMessage)querySaver;
                    String cmd = redoable.getCommand();
                    Prepare prepare = this.context.getPrepareCacheCmd(cmd, redoable.prep());
                    if (prepare == null) {
                        PreparePacket preparePacket = new PreparePacket(cmd);
                        this.sendQuery(preparePacket);
                        prepare = (PrepareResultPacket)this.readPacket(preparePacket);
                        logger.info("replayed command after failover: " + preparePacket.description());
                    }
                    responseNo = querySaver.reEncode(this.writer, this.context, prepare);
                } else {
                    responseNo = querySaver.reEncode(this.writer, this.context, null);
                }
                logger.info("replayed command after failover: " + querySaver.description());
                for (int j = 0; j < responseNo; ++j) {
                    this.readResponse(querySaver);
                }
            }
        }
        catch (IOException e) {
            throw this.context.getExceptionFactory().create("Socket error during transaction replay", "08000", e);
        }
    }
}

