/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.column;

import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.Configuration;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ColumnDecoder;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.DataType;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.ReadableByteBuf;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.client.column.StringColumn;
import io.github.lijinhong11.supermines.libraries.database.libs.mariadb.util.CharsetEncodingLength;

public class JsonColumn
extends StringColumn
implements ColumnDecoder {
    public JsonColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    protected JsonColumn(JsonColumn prev) {
        super(prev);
    }

    @Override
    public int getDisplaySize() {
        if (this.charset != 63) {
            Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
            if (maxWidth != null) {
                return (int)(this.columnLength / (long)maxWidth.intValue());
            }
            return (int)(this.columnLength / 4L);
        }
        return (int)this.columnLength;
    }

    @Override
    public JsonColumn useAliasAsName() {
        return new JsonColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return String.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -1;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "JSON";
    }
}

