/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.libraries.database.impl;

import io.github.lijinhong11.supermines.libraries.database.DatabaseConnection;
import io.github.lijinhong11.supermines.libraries.database.enums.DatabaseType;
import io.github.lijinhong11.supermines.libraries.database.serialization.ObjectSerializer;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.AutoIncrement;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Column;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.PrimaryKey;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Table;
import io.github.lijinhong11.supermines.libraries.database.sql.conditions.Condition;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.CreateTableSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.DeleteSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.InsertSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.SelectSQL;
import io.github.lijinhong11.supermines.libraries.database.sql.sentence.UpdateSQL;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSQLConnection
implements DatabaseConnection {
    private static final Logger LOGGER = Logger.getLogger("MXDatabase");
    private boolean debug = false;

    AbstractSQLConnection() {
    }

    abstract Connection getConnection() throws SQLException;

    @Override
    @NotNull
    public abstract DatabaseType getType();

    @Override
    public abstract void close();

    @Override
    public boolean execute(SQL sql) throws SQLException {
        try (Connection connection = this.getConnection();){
            boolean bl = sql.build(connection, this.getType()).execute();
            return bl;
        }
    }

    @Override
    public ResultSet query(SelectSQL sql) throws SQLException {
        try (Connection connection = this.getConnection();){
            ResultSet resultSet = sql.build(connection, this.getType()).executeQuery();
            return resultSet;
        }
    }

    @Override
    @NotNull
    public <T> T selectOne(Class<T> clazz, @NotNull Condition condition) throws SQLException {
        if (!clazz.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException("the class must be annotated with @Table");
        }
        Table table = clazz.getAnnotation(Table.class);
        if (Objects.isNull(table.name()) || table.name().isBlank()) {
            throw new IllegalArgumentException("the table name cannot be empty");
        }
        SelectSQL sql = SQL.select().allColumns().from(table.name()).where(condition).limit(1);
        if (this.debug) {
            LOGGER.info("Invoking SQL: " + sql.getSql(this.getType()));
        }
        ResultSet query = this.query(sql);
        return ObjectSerializer.serializeOne(clazz, query);
    }

    @Override
    @NotNull
    public <T> List<T> selectMulti(@NotNull Class<T> clazz) throws SQLException {
        return this.selectMulti(clazz, null);
    }

    @Override
    @NotNull
    public <T> List<T> selectMulti(@NotNull Class<T> clazz, @Nullable Condition condition) throws SQLException {
        if (!clazz.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException("the class must be annotated with @Table");
        }
        Table table = clazz.getAnnotation(Table.class);
        if (Objects.isNull(table.name()) || table.name().isBlank()) {
            throw new IllegalArgumentException("the table name cannot be empty");
        }
        SelectSQL sql = SQL.select().allColumns().from(table.name());
        if (condition != null) {
            sql.where(condition);
        }
        if (this.debug) {
            LOGGER.info("Invoking SQL: " + sql.getSql(this.getType()));
        }
        ResultSet set = this.query(sql);
        return ObjectSerializer.serializeMulti(clazz, set);
    }

    @Override
    public boolean ping() throws SQLException {
        try (Connection connection = this.getConnection();){
            boolean bl = connection.isValid(1);
            return bl;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (Connection connection = this.getConnection();){
            connection.rollback();
        }
    }

    @Override
    public void commit() throws SQLException {
        try (Connection connection = this.getConnection();){
            connection.commit();
        }
    }

    @Override
    public void createTableByClass(@NotNull Class<?> clazz) throws SQLException {
        if (!clazz.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException("the class must be annotated with @Table");
        }
        Table table = clazz.getAnnotation(Table.class);
        if (Objects.isNull(table.name()) || table.name().isBlank()) {
            throw new IllegalArgumentException("the table name cannot be empty");
        }
        List<Field> field = ObjectSerializer.getAllFields(clazz);
        CreateTableSQL sql = SQL.createTable().table(table.name()).ifNotExists();
        for (Field f : field) {
            Column column;
            if (!f.isAnnotationPresent(Column.class) || (column = f.getAnnotation(Column.class)) == null) continue;
            Class<?> type = f.getType();
            String sqlType = ObjectSerializer.getSqlType(type);
            String columnName = ObjectSerializer.getColumnName(f);
            sql.column(columnName, sqlType);
            if (f.isAnnotationPresent(AutoIncrement.class)) {
                sql.autoIncrement(columnName);
            }
            if (f.isAnnotationPresent(PrimaryKey.class)) {
                sql.primaryKey(columnName);
            }
            if (!column.nullable()) {
                sql.notNull(columnName);
            }
            if (Objects.isNull(column.defaultValue()) || column.defaultValue().isBlank()) continue;
            sql.defaultValue(columnName, column.defaultValue());
        }
        if (this.debug) {
            LOGGER.info("Invoking SQL: " + sql.getSql(this.getType()));
        }
        sql.build(this.getConnection(), this.getType()).execute();
    }

    @Override
    public <T> void insertObject(@NotNull Class<T> clazz, @NotNull T object, boolean upsert) throws SQLException {
        if (!clazz.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException("the class must be annotated with @Table");
        }
        Table table = clazz.getAnnotation(Table.class);
        if (Objects.isNull(table.name()) || table.name().isBlank()) {
            throw new IllegalArgumentException("the table name cannot be empty");
        }
        List<Field> fields = ObjectSerializer.getAllFields(clazz);
        InsertSQL sql = upsert ? SQL.upsert().into(table.name()) : SQL.insert().into(table.name());
        ArrayList<String> conflictKeys = new ArrayList<String>();
        for (Field f : fields) {
            boolean isPrimary;
            if (!f.isAnnotationPresent(Column.class)) continue;
            String columnName = ObjectSerializer.getColumnName(f);
            try {
                sql.value(columnName, ObjectSerializer.convertBack(f.get(object)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (!upsert || this.getType() != DatabaseType.SQLITE && this.getType() != DatabaseType.POSTGRESQL || !(isPrimary = f.isAnnotationPresent(PrimaryKey.class))) continue;
            conflictKeys.add(columnName);
        }
        if (upsert && (this.getType() == DatabaseType.SQLITE || this.getType() == DatabaseType.POSTGRESQL)) {
            if (conflictKeys.isEmpty()) {
                throw new IllegalStateException("Upsert requires at least one @PrimaryKey or @Column(primaryKey=true) in " + clazz.getName());
            }
            sql = sql.conflictKeys(conflictKeys.toArray(new String[0]));
        }
        if (this.debug) {
            LOGGER.info("Invoking SQL: " + sql.getSql(this.getType()));
        }
        sql.build(this.getConnection(), this.getType()).execute();
    }

    @Override
    public <T> void updateObject(@NotNull Class<T> clazz, @NotNull T object, @NotNull Condition condition) throws SQLException {
        if (!clazz.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException("the class must be annotated with @Table");
        }
        Table table = clazz.getAnnotation(Table.class);
        if (Objects.isNull(table.name()) || table.name().isBlank()) {
            throw new IllegalArgumentException("the table name cannot be empty");
        }
        List<Field> field = ObjectSerializer.getAllFields(clazz);
        UpdateSQL sql = SQL.update().table(table.name());
        for (Field f : field) {
            if (!f.isAnnotationPresent(Column.class)) continue;
            String columnName = ObjectSerializer.getColumnName(f);
            if (f.isAnnotationPresent(PrimaryKey.class)) continue;
            try {
                sql = sql.set(columnName, ObjectSerializer.convertBack(f.get(object)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        sql.where(condition);
        if (this.debug) {
            LOGGER.info("Invoking SQL: " + sql.getSql(this.getType()));
        }
        sql.build(this.getConnection(), this.getType()).execute();
    }

    @Override
    public void deleteObject(@NotNull Class<?> clazz, @NotNull Condition condition) throws SQLException {
        if (!clazz.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException("the class must be annotated with @Table");
        }
        Table table = clazz.getAnnotation(Table.class);
        if (Objects.isNull(table.name()) || table.name().isBlank()) {
            throw new IllegalArgumentException("the table name cannot be empty");
        }
        DeleteSQL sql = SQL.delete().from(table.name()).where(condition);
        if (this.debug) {
            LOGGER.info("Invoking SQL: " + sql.getSql(this.getType()));
        }
        sql.build(this.getConnection(), this.getType()).execute();
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

