/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.integrates;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.data.PlayerData;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.utils.NumberUtils;
import io.github.miniplaceholders.api.Expansion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class MiniPlaceholderExtension {
    public static void register() {
        Expansion expansion = (Expansion)Expansion.builder((String)"supermines").audiencePlaceholder("rank", (a, args, ctx) -> {
            if (args.hasNext()) {
                String playerName = args.pop().value();
                OfflinePlayer p2 = Bukkit.getOfflinePlayer((String)playerName);
                PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p2.getUniqueId());
                return Tag.selfClosingInserting((Component)data.getRank().getDisplayName());
            }
            Player p = (Player)a;
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p.getUniqueId());
            return Tag.selfClosingInserting((Component)data.getRank().getDisplayName());
        }).audiencePlaceholder("rankLevel", (a, args, ctx) -> {
            if (args.hasNext()) {
                String playerName = args.pop().value();
                OfflinePlayer p2 = Bukkit.getOfflinePlayer((String)playerName);
                PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p2.getUniqueId());
                return Tag.selfClosingInserting((Component)Component.text((int)data.getRank().getLevel()));
            }
            Player p = (Player)a;
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p.getUniqueId());
            return Tag.selfClosingInserting((Component)Component.text((int)data.getRank().getLevel()));
        }).audiencePlaceholder("minedBlocks", (a, args, ctx) -> {
            if (args.hasNext()) {
                String playerName = args.pop().value();
                OfflinePlayer p2 = Bukkit.getOfflinePlayer((String)playerName);
                PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p2.getUniqueId());
                return Tag.selfClosingInserting((Component)Component.text((int)data.getMinedBlocks()));
            }
            Player p = (Player)a;
            PlayerData data = SuperMines.getInstance().getPlayerDataManager().getOrCreatePlayerData(p.getUniqueId());
            return Tag.selfClosingInserting((Component)Component.text((int)data.getMinedBlocks()));
        }).globalPlaceholder("mine_blocksbroken", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            return Tag.selfClosingInserting((Component)Component.text((int)mine.getBlocksBroken()));
        }).globalPlaceholder("mine_resettime", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            int millis = (int)(SuperMines.getInstance().getTaskMaker().getMineUntilResetTime(mine) * 1000L);
            return Tag.selfClosingInserting((Component)Component.text((String)NumberUtils.formatSeconds(null, millis)));
        }).globalPlaceholder("mine_blockpercent", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            int broken = mine.getBlocksBroken();
            int total = mine.getArea().volume();
            double percent = total == 0 ? 100.0 : (double)(total - broken) / (double)total * 100.0;
            return Tag.selfClosingInserting((Component)Component.text((String)String.format("%.2f", percent)));
        }).globalPlaceholder("mine_minedpercent", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            int broken = mine.getBlocksBroken();
            int total = mine.getArea().volume();
            double percent = total == 0 ? 0.0 : (double)broken / (double)total * 100.0;
            return Tag.selfClosingInserting((Component)Component.text((String)String.format("%.2f", percent)));
        }).globalPlaceholder("totalblocks", (args, ctx) -> {
            String mineId = args.popOr("missing_mine_id").value();
            Mine mine = SuperMines.getInstance().getMineManager().getMine(mineId);
            if (mine == null) {
                return Tag.selfClosingInserting((Component)Component.text((String)"MINE_NOT_FOUND"));
            }
            return Tag.selfClosingInserting((Component)Component.text((int)mine.getArea().volume()));
        }).build();
        expansion.register();
    }
}

