/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.gui;

import io.github.lijinhong11.supermines.SuperMines;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.api.mine.Mine;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.gui.ListGUI;
import io.github.lijinhong11.supermines.libraries.gui.builder.gui.PaginatedBuilder;
import io.github.lijinhong11.supermines.libraries.gui.builder.gui.SimpleBuilder;
import io.github.lijinhong11.supermines.libraries.gui.builder.item.ItemBuilder;
import io.github.lijinhong11.supermines.libraries.gui.components.util.GuiFiller;
import io.github.lijinhong11.supermines.libraries.gui.guis.BaseGui;
import io.github.lijinhong11.supermines.libraries.gui.guis.Gui;
import io.github.lijinhong11.supermines.libraries.gui.guis.GuiItem;
import io.github.lijinhong11.supermines.libraries.gui.guis.PaginatedGui;
import io.github.lijinhong11.supermines.message.MessageReplacement;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.Constants;
import io.github.lijinhong11.supermines.utils.chat.ChatInput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GuiManager {
    public static void openGeneral(Player p) {
        Gui gui = ((SimpleBuilder)((SimpleBuilder)Gui.gui().title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.general.title", new MessageReplacement[0]))).rows(3)).create();
        gui.setItem(2, 3, ItemBuilder.from(Constants.Items.MINES.apply(p)).asGuiItem(e -> {
            GuiManager.openMineList(p);
            e.setCancelled(true);
        }));
        gui.setItem(2, 5, ItemBuilder.from(Constants.Items.TREASURES.apply(p)).asGuiItem(e -> {
            GuiManager.openTreasureList(p);
            e.setCancelled(true);
        }));
        gui.setItem(2, 7, ItemBuilder.from(Constants.Items.RANKS.apply(p)).asGuiItem(e -> {
            GuiManager.openRankList(p);
            e.setCancelled(true);
        }));
        gui.open((HumanEntity)p);
    }

    public static void openMineList(Player p) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().pageSize(45).rows(6)).title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.mines.title", new MessageReplacement[0]))).create();
        GuiManager.fillPageButtons(p, gui, () -> GuiManager.openGeneral(p));
        for (Mine mine : SuperMines.getInstance().getMineManager().getAllMines()) {
            Material mat = mine.getDisplayIcon() == null ? Constants.Items.DEFAULT_MINE_ICON : mine.getDisplayIcon();
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(mat).name(mine.getDisplayName())).lore(SuperMines.getInstance().getLanguageManager().getMineInfo(p, mine))).asGuiItem(e -> {
                GuiManager.openMineManagementGui(p, mine);
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
    }

    public static void openMineManagementGui(Player p, Mine mine) {
        MessageReplacement mineName = MessageReplacement.replace("%mine%", mine.getRawDisplayName());
        Gui gui = ((SimpleBuilder)((SimpleBuilder)Gui.gui().title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.mine-management.title", mineName))).rows(6)).create();
        GuiManager.placeCommon(p, gui, mine, mine.getDisplayIcon(), () -> GuiManager.openMineManagementGui(p, mine), () -> GuiManager.openMineList(p));
        GuiManager.putItem(3, 4, gui, ItemBuilder.from(Constants.Items.SET_DISPLAY_ICON.apply(p, mine.getDisplayIcon())), e -> {
            Material m = GuiManager.openMaterialChooser(p, mt -> true, () -> GuiManager.openMineManagementGui(p, mine));
            mine.setDisplayIcon(m);
            GuiManager.openMineManagementGui(p, mine);
        });
        GuiManager.putItem(3, 6, gui, ItemBuilder.from(Constants.Items.SET_REGEN_SECONDS.apply(p, mine.getRegenerateSeconds())), e -> {
            if (!p.hasPermission("supermines.set_reset_time")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.set_reset_time.prompt", new MessageReplacement[0]);
            ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
                if (result.equalsIgnoreCase("##CANCEL")) {
                    return;
                }
                try {
                    int time = Integer.parseUnsignedInt(result);
                    mine.setRegenerateSeconds(time);
                    SuperMines.getInstance().getTaskMaker().restartMineResetTask(mine);
                }
                catch (NumberFormatException ex) {
                    SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.input.invalid-number", new MessageReplacement[0]);
                }
                GuiManager.openMineManagementGui(p, mine);
            });
        });
        GuiManager.putItem(3, 8, gui, ItemBuilder.from(Constants.Items.ONLY_FILL_AIR.apply(p, mine.isOnlyFillAirWhenRegenerate())), e -> {
            if (!p.hasPermission("supermines.set_only_fill_air")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            mine.setOnlyFillAirWhenRegenerate(!mine.isOnlyFillAirWhenRegenerate());
            GuiManager.openMineManagementGui(p, mine);
        });
        GuiManager.putItem(4, 3, gui, ItemBuilder.from(Constants.Items.SET_REQUIRED_RANK_LEVEL.apply(p, mine.getRequiredRankLevel())), e -> {
            if (!p.hasPermission("supermines.set_required_level")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.set_required_lvl.prompt", new MessageReplacement[0]);
            ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
                if (result.equalsIgnoreCase("##CANCEL")) {
                    return;
                }
                try {
                    int lvl = Integer.parseUnsignedInt(result);
                    mine.setRequiredRankLevel(lvl);
                    SuperMines.getInstance().getTaskMaker().restartMineResetTask(mine);
                }
                catch (NumberFormatException ex) {
                    SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.input.invalid-number", new MessageReplacement[0]);
                }
                GuiManager.openMineManagementGui(p, mine);
            });
        });
        GuiManager.putItem(4, 5, gui, ItemBuilder.from(Constants.Items.BLOCK_SPAWN_ENTRIES.apply(p)), e -> {
            if (!p.hasPermission("supermines.block_generates")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            GuiManager.openBlockSpawnEntries(p, mine);
        });
        gui.open((HumanEntity)p);
    }

    private static void openBlockSpawnEntries(Player p, Mine mine) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().rows(6)).pageSize(45).title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.mine-management.block_spawn.title", new MessageReplacement[0]))).create();
        GuiManager.fillPageButtons(p, gui, () -> GuiManager.openMineManagementGui(p, mine));
        GuiManager.putItem(6, 1, gui, ItemBuilder.from(Constants.Items.ADD.apply(p)), e -> {
            Material m = GuiManager.openMaterialChooser(p, Material::isBlock, () -> {});
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.block_spawn.add_prompt", MessageReplacement.replace("%material%", m.toString()));
            GuiManager.addBlockSpawnEntry(p, mine, m);
        });
        for (Map.Entry<Material, Double> entry : mine.getBlockSpawnEntries().entrySet()) {
            MessageReplacement r = MessageReplacement.replace("%precent%", String.valueOf(entry.getValue()));
            List<Component> lore = SuperMines.getInstance().getLanguageManager().getMsgComponentList((CommandSender)p, "gui.mine-management.block_spawn.each_lore", r);
            GuiItem item = ((ItemBuilder)ItemBuilder.from(entry.getKey()).lore(lore)).asGuiItem(e -> {
                if (!p.hasPermission("supermines.block_generates")) {
                    SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                    return;
                }
                ClickType type = e.getClick();
                Material material = (Material)entry.getKey();
                if (type.isLeftClick()) {
                    gui.close((HumanEntity)p);
                    SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.mine-management.block_spawn.set_precent_prompt", MessageReplacement.replace("%material%", material.toString()));
                    GuiManager.addBlockSpawnEntry(p, mine, material);
                } else if (type.isRightClick()) {
                    mine.removeBlockSpawnEntry(material);
                    GuiManager.openBlockSpawnEntries(p, mine);
                }
                e.setCancelled(true);
            });
            gui.addItem(item);
        }
        gui.open((HumanEntity)p);
    }

    private static void addBlockSpawnEntry(Player p, Mine mine, Material material) {
        ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
            if (result.equalsIgnoreCase("##CANCEL")) {
                return;
            }
            try {
                double d = Double.parseDouble(result);
                if (d >= 100.0 || d < 0.0) {
                    throw new NumberFormatException();
                }
                mine.addBlockSpawnEntry(material, d);
            }
            catch (NumberFormatException ex) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.input.invalid-precent", new MessageReplacement[0]);
            }
            GuiManager.openBlockSpawnEntries(p, mine);
        });
    }

    public static void openTreasureList(Player p) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().pageSize(45).rows(6)).title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.treasures.title", new MessageReplacement[0]))).create();
        GuiManager.fillPageButtons(p, gui, () -> GuiManager.openGeneral(p));
        for (Treasure treasure : SuperMines.getInstance().getTreasureManager().getAllTreasures()) {
            Material mat = Material.CHEST;
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(mat).name(treasure.getDisplayName())).lore(SuperMines.getInstance().getLanguageManager().getTreasureInfo(p, treasure))).asGuiItem(e -> {
                GuiManager.openTreasureManagementGui(p, treasure);
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
    }

    public static void openTreasureManagementGui(Player p, Treasure treasure) {
        MessageReplacement treasureName = MessageReplacement.replace("%treasure%", treasure.getRawDisplayName());
        Gui gui = ((SimpleBuilder)((SimpleBuilder)Gui.gui().title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.treasure-management.title", treasureName))).rows(6)).create();
        GuiManager.placeCommon(p, gui, treasure, Material.CHEST, () -> GuiManager.openTreasureManagementGui(p, treasure), () -> GuiManager.openTreasureList(p));
        GuiManager.putItem(3, 4, gui, ItemBuilder.from(Constants.Items.SET_CHANCE.apply(p, treasure.getChance())), e -> {
            if (!p.hasPermission("supermines.treasures")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.treasure-management.set_chance.prompt", new MessageReplacement[0]);
            ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
                if (result.equalsIgnoreCase("##CANCEL")) {
                    return;
                }
                try {
                    double d = Double.parseDouble(result);
                    if (d >= 100.0 || d < 0.0) {
                        throw new NumberFormatException();
                    }
                    treasure.setChance(d);
                }
                catch (NumberFormatException ex) {
                    SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.input.invalid-precent", new MessageReplacement[0]);
                }
                GuiManager.openTreasureManagementGui(p, treasure);
            });
        });
        GuiManager.putItem(3, 8, gui, ItemBuilder.from(Constants.Items.MATCHED_MATERIALS.apply(p)), e -> GuiManager.openMatchedMaterials(p, treasure));
        GuiManager.putTreasureItemStack(gui, p, treasure);
    }

    private static void putTreasureItemStack(BaseGui gui, Player p, Treasure t) {
        ItemStack clone = t.getItemStack().clone();
        ItemMeta meta = clone.getItemMeta();
        Component newName = SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.treasure-management.itemstack.name", MessageReplacement.replace("%name%", ComponentUtils.serialize(meta.displayName())));
        meta.displayName(newName);
        meta.lore(SuperMines.getInstance().getLanguageManager().getMsgComponentList((CommandSender)p, "gui.treasure-management.itemstack.lore", new MessageReplacement[0]));
        clone.setItemMeta(meta);
        GuiManager.putItem(3, 6, gui, ItemBuilder.from(clone), e -> {
            ItemStack item;
            if (!p.hasPermission("supermines.treasures")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            ClickType type = e.getClick();
            if (type.isRightClick()) {
                if (p.getInventory().firstEmpty() != -1) {
                    p.getInventory().addItem(new ItemStack[]{t.getItemStack()});
                }
            } else if (type.isLeftClick() && !(item = p.getItemOnCursor()).getType().isAir()) {
                t.setItemStack(item);
                GuiManager.putTreasureItemStack(gui, p, t);
            }
        });
    }

    private static void openMatchedMaterials(Player p, Treasure treasure) {
        ListGUI.openList(p, SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.treasure-management.matched_materials.title", new MessageReplacement[0]), treasure.getMatchedMaterials(), m -> {
            List<Component> lore = SuperMines.getInstance().getLanguageManager().getMsgComponentList((CommandSender)p, "gui.treasure-management.matched_materials.each_lore", new MessageReplacement[0]);
            return ((ItemBuilder)ItemBuilder.from(m).lore(lore)).build();
        }, treasure::removeMatchedMaterial, () -> {
            Material m = GuiManager.openMaterialChooser(p, Material::isBlock, () -> {});
            if (!treasure.getMatchedMaterials().contains(m)) {
                treasure.addMatchedMaterial(m);
            }
            GuiManager.openMatchedMaterials(p, treasure);
        }, () -> GuiManager.openTreasureManagementGui(p, treasure));
    }

    public static void openRankList(Player p) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().pageSize(45).rows(6)).title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.ranks.title", new MessageReplacement[0]))).create();
        GuiManager.fillPageButtons(p, gui, () -> GuiManager.openGeneral(p));
        for (Rank rank : SuperMines.getInstance().getRankManager().getAllRanks()) {
            Material mat = Material.NAME_TAG;
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(mat).name(rank.getDisplayName())).lore(SuperMines.getInstance().getLanguageManager().getRankInfo(p, rank))).asGuiItem(e -> {
                GuiManager.openRankManagementGui(p, rank);
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
    }

    public static void openRankManagementGui(Player p, Rank rank) {
        MessageReplacement rankName = MessageReplacement.replace("%rank%", rank.getRawDisplayName());
        Gui gui = ((SimpleBuilder)((SimpleBuilder)Gui.gui().title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.rank-management.title", rankName))).rows(6)).create();
        GuiManager.placeCommon(p, gui, rank, Material.NAME_TAG, () -> GuiManager.openRankManagementGui(p, rank), () -> GuiManager.openRankList(p));
        GuiManager.putItem(3, 4, gui, ItemBuilder.from(Constants.Items.SET_RANK_LEVEL.apply(p, rank.getLevel())), e -> {
            if (!p.hasPermission("supermines.ranks")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.rank-management.setlevel.prompt", new MessageReplacement[0]);
            ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
                if (result.equalsIgnoreCase("##CANCEL")) {
                    return;
                }
                try {
                    int lvl = Integer.parseUnsignedInt(result);
                    rank.setLevel(lvl);
                }
                catch (NumberFormatException ex) {
                    SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.input.invalid-number", new MessageReplacement[0]);
                }
                GuiManager.openRankManagementGui(p, rank);
            });
        });
    }

    private static void fillPageButtons(Player p, PaginatedGui gui, Runnable reopen) {
        gui.getFiller().fillBetweenPoints(6, 1, 6, 9, ItemBuilder.from(Constants.Items.BACKGROUND).asGuiItem(e -> e.setCancelled(true)));
        GuiManager.putItem(6, 1, gui, ItemBuilder.from(Constants.Items.CLOSE.apply(p)), e -> gui.close((HumanEntity)p));
        GuiManager.putItem(6, 3, gui, ItemBuilder.from(Constants.Items.PREVIOUS_PAGE.apply(p)), e -> gui.previous());
        GuiManager.putItem(6, 7, gui, ItemBuilder.from(Constants.Items.NEXT_PAGE.apply(p)), e -> gui.next());
        GuiManager.putItem(6, 9, gui, ItemBuilder.from(Constants.Items.BACK.apply(p)), e -> reopen.run());
    }

    static void putItem(int row, int col, BaseGui gui, ItemBuilder item, Consumer<InventoryClickEvent> clickEventConsumer) {
        gui.setItem(row, col, item.asGuiItem(e -> {
            clickEventConsumer.accept((InventoryClickEvent)e);
            e.setCancelled(true);
        }));
    }

    private static <T extends Identified> void placeCommon(Player p, Gui gui, T object, Material icon, Runnable reopen, Runnable back) {
        GuiFiller filler = gui.getFiller();
        filler.fillBorder(ItemBuilder.from(Constants.Items.BACKGROUND).asGuiItem(e -> e.setCancelled(true)));
        GuiManager.putItem(2, 5, gui, (ItemBuilder)((ItemBuilder)ItemBuilder.from(icon).name(object.getDisplayName())).lore(ComponentUtils.deserialize("&7&lID: " + object.getId())), e -> {});
        GuiManager.putItem(3, 2, gui, ItemBuilder.from(Constants.Items.SET_DISPLAY_NAME.apply(p, object)), e -> {
            if (!p.hasPermission("supermines.set_display_name")) {
                SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "common.no-permission", new MessageReplacement[0]);
                return;
            }
            gui.close((HumanEntity)p);
            SuperMines.getInstance().getLanguageManager().sendMessage((CommandSender)p, "gui.set_display_name.prompt", new MessageReplacement[0]);
            ChatInput.waitForPlayer((Plugin)SuperMines.getInstance(), p, result -> {
                if (result.equalsIgnoreCase("##CANCEL")) {
                    return;
                }
                object.setDisplayName(ComponentUtils.deserialize(result));
                reopen.run();
            });
        });
        GuiManager.putItem(1, 9, gui, ItemBuilder.from(Constants.Items.BACK.apply(p)), e -> back.run());
    }

    private static Material openMaterialChooser(Player p, Predicate<Material> predicate, Runnable reopen) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(SuperMines.getInstance().getLanguageManager().getMsgComponent((CommandSender)p, "gui.material-chooser.title", new MessageReplacement[0]))).rows(6)).create();
        GuiManager.fillPageButtons(p, gui, reopen);
        AtomicReference selected = new AtomicReference();
        for (Material material : Material.values()) {
            if (material.isAir() || !predicate.test(material)) continue;
            GuiItem guiItem = ItemBuilder.from(material).asGuiItem(e -> {
                selected.set(material);
                reopen.run();
                e.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.open((HumanEntity)p);
        return (Material)selected.get();
    }
}

