/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.mine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.lijinhong11.supermines.api.SuperMinesAPI;
import io.github.lijinhong11.supermines.api.data.PlayerData;
import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.api.mine.Treasure;
import io.github.lijinhong11.supermines.api.pos.BlockPos;
import io.github.lijinhong11.supermines.api.pos.CuboidArea;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.Constants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.ParametersAreNonnullByDefault;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class Mine
implements Identified {
    private final String id;
    private final World world;
    private final Map<Material, Double> blockSpawnEntries;
    private final List<Treasure> treasures;
    private final Set<String> allowedRankIds;
    private final Set<Integer> warningSeconds;
    private final AtomicInteger blocksBroken = new AtomicInteger(0);
    private Material displayIcon;
    private Component displayName;
    private CuboidArea area;
    private int regenerateSeconds;
    private boolean onlyFillAirWhenRegenerate;
    private int requiredRankLevel;
    private Location tpLoc;

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, World world, CuboidArea area, Map<Material, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate) {
        this(id, displayName, Constants.Items.DEFAULT_MINE_ICON, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate);
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<Material, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate) {
        this(id, displayName, displayIcon, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate, new ArrayList<Treasure>(), new HashSet<String>());
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<Material, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate, List<Treasure> treasures, Set<String> allowedRankIds) {
        this(id, displayName, displayIcon, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate, treasures, Rank.DEFAULT.getLevel(), allowedRankIds);
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<Material, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate, List<Treasure> treasures, int requiredRankLevel, Set<String> allowedRankIds) {
        this(id, displayName, displayIcon, world, area, blockSpawnEntries, regenerateSeconds, onlyFillAirWhenRegenerate, treasures, requiredRankLevel, allowedRankIds, null, new HashSet<Integer>());
    }

    @ParametersAreNonnullByDefault
    public Mine(String id, Component displayName, Material displayIcon, World world, CuboidArea area, Map<Material, Double> blockSpawnEntries, int regenerateSeconds, boolean onlyFillAirWhenRegenerate, List<Treasure> treasures, int requiredRankLevel, Set<String> allowedRankIds, @Nullable Location tpLoc, Set<Integer> warningSeconds) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"Mine ID cannot be null or empty");
        Preconditions.checkArgument((boolean)id.matches("^[a-zA-Z0-9_-]+$"), (Object)"Mine ID cannot contain special characters");
        this.id = id;
        this.displayName = displayName;
        this.displayIcon = displayIcon;
        this.world = world;
        this.area = area;
        this.onlyFillAirWhenRegenerate = onlyFillAirWhenRegenerate;
        this.blockSpawnEntries = blockSpawnEntries;
        this.regenerateSeconds = regenerateSeconds;
        this.treasures = treasures;
        this.requiredRankLevel = requiredRankLevel;
        this.allowedRankIds = allowedRankIds;
        this.warningSeconds = warningSeconds;
        this.tpLoc = tpLoc == null ? area.getCenterLocation(world) : tpLoc;
    }

    public boolean isPlayerInMine(@NotNull Player player) {
        return this.area.contains(BlockPos.fromLocation(player.getLocation()));
    }

    public void addTreasure(@NotNull String id) {
        this.treasures.add(SuperMinesAPI.getTreasure(id));
    }

    public void addTreasure(@NotNull Treasure treasure) {
        this.treasures.add(treasure);
    }

    public void removeTreasure(@NotNull String id) {
        this.treasures.removeIf(treasure -> treasure.getId().equals(id));
    }

    public void removeTreasure(@NotNull Treasure treasure) {
        this.treasures.remove(treasure);
    }

    public void setTreasures(@NotNull List<Treasure> treasures) {
        this.treasures.clear();
        this.treasures.addAll(treasures);
    }

    public void addBlockSpawnEntry(@NotNull Material material, double chance) {
        if (chance < 1.0 || chance > 100.0) {
            throw new IllegalArgumentException("Chance must be between 1 and 100");
        }
        this.blockSpawnEntries.put(material, chance);
    }

    public void addBlockSpawnEntries(Map<Material, Double> blockSpawnEntries) {
        this.blockSpawnEntries.putAll(blockSpawnEntries);
    }

    public void removeBlockSpawnEntry(@NotNull Material material) {
        this.blockSpawnEntries.remove(material);
    }

    public void removeBlockSpawnEntries(List<Material> materials) {
        materials.forEach(this.blockSpawnEntries::remove);
    }

    public void addAllowedRankId(String rankId) {
        this.allowedRankIds.add(rankId);
    }

    public void removeAllowedRankId(String rankId) {
        this.allowedRankIds.remove(rankId);
    }

    public void setAllowedRankIds(Collection<String> rankIds) {
        this.allowedRankIds.clear();
        this.allowedRankIds.addAll(rankIds);
    }

    public Set<String> getAllowedRankIds() {
        return this.allowedRankIds;
    }

    public void setTeleportLocation(@NotNull Location tpLoc) {
        Preconditions.checkNotNull((Object)tpLoc, (Object)"teleport location cannot be null");
        this.tpLoc = tpLoc;
    }

    @Nullable
    public Location getTeleportLocation() {
        return this.tpLoc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRawDisplayName() {
        return ComponentUtils.serialize(this.getDisplayName());
    }

    @Override
    public void setDisplayName(@NotNull Component displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"display name cannot be null");
        this.displayName = displayName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName == null ? Constants.StringsAndComponents.RESET.append((Component)Component.text((String)this.id)) : this.displayName;
    }

    public void setDisplayIcon(Material displayIcon) {
        Preconditions.checkNotNull((Object)displayIcon, (Object)"display icon cannot be null");
        this.displayIcon = displayIcon;
    }

    public Material getDisplayIcon() {
        return this.displayIcon;
    }

    public World getWorld() {
        return this.world;
    }

    public void setArea(@NotNull CuboidArea area) {
        Preconditions.checkNotNull((Object)area, (Object)"area cannot be null");
        this.area = area;
    }

    public CuboidArea getArea() {
        return this.area;
    }

    public List<Treasure> getTreasures() {
        return this.treasures;
    }

    public Map<Material, Double> getBlockSpawnEntries() {
        return this.blockSpawnEntries;
    }

    public void setRegenerateSeconds(@Range(from=0L, to=0x7FFFFFFFL) int regenerateSeconds) {
        Preconditions.checkArgument((regenerateSeconds >= 0 ? 1 : 0) != 0, (Object)"regenerate seconds must equal to or greater than 0");
        this.regenerateSeconds = regenerateSeconds;
    }

    public int getRegenerateSeconds() {
        return this.regenerateSeconds;
    }

    public void setOnlyFillAirWhenRegenerate(boolean onlyFillAirWhenRegenerate) {
        this.onlyFillAirWhenRegenerate = onlyFillAirWhenRegenerate;
    }

    public boolean isOnlyFillAirWhenRegenerate() {
        return this.onlyFillAirWhenRegenerate;
    }

    public void setRequiredRankLevel(int requiredRankLevel) {
        this.requiredRankLevel = requiredRankLevel;
    }

    public void setRequiredRankLevel(Rank requiredRank) {
        this.requiredRankLevel = requiredRank.getLevel();
    }

    public int getRequiredRankLevel() {
        return this.requiredRankLevel;
    }

    public int getBlocksBroken() {
        return this.blocksBroken.get();
    }

    public void setBlocksBroken(int blocksBroken) {
        this.blocksBroken.set(blocksBroken);
    }

    public void plusBlocksBroken() {
        this.blocksBroken.incrementAndGet();
    }

    public void setWarningSeconds(Set<Integer> warningSeconds) {
        this.warningSeconds.clear();
        this.warningSeconds.addAll(warningSeconds);
    }

    public Set<Integer> getWarningSeconds() {
        return this.warningSeconds;
    }

    public double calculateRestChance() {
        double max = 100.0;
        for (double chance : this.blockSpawnEntries.values()) {
            max -= chance;
        }
        return max;
    }

    public boolean canMine(Player p) {
        PlayerData data = SuperMinesAPI.getOrCreatePlayerData(p.getUniqueId());
        Rank rank = data.getRank();
        if (p.isOp() || p.hasPermission("supermines.bypass.rank")) {
            return true;
        }
        if (this.allowedRankIds.isEmpty()) {
            return true;
        }
        if (this.allowedRankIds.contains(rank.getId())) {
            return true;
        }
        return rank.getLevel() >= this.requiredRankLevel;
    }
}

