/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.data;

import com.google.common.base.Preconditions;
import io.github.lijinhong11.supermines.api.iface.Identified;
import io.github.lijinhong11.supermines.utils.ComponentUtils;
import io.github.lijinhong11.supermines.utils.Constants;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public final class Rank
implements Identified {
    public static final Rank DEFAULT = new Rank(1, "default", Constants.StringsAndComponents.RESET.append((Component)Component.text((String)"Default")));
    private final String id;
    private int level;
    private Component displayName;

    public Rank(int level, String id, Component displayName) {
        if (level <= 0) {
            throw new IllegalArgumentException("Rank level must be greater than 0");
        }
        this.level = level;
        this.id = id;
        this.displayName = displayName;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("rank level must be greater than 0");
        }
        this.level = level;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRawDisplayName() {
        return ComponentUtils.serialize(this.getDisplayName());
    }

    @Override
    public Component getDisplayName() {
        return Constants.StringsAndComponents.RESET.append(this.displayName);
    }

    @Override
    public void setDisplayName(@NotNull Component displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"display name cannot be null");
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rank)) {
            return false;
        }
        Rank r = (Rank)o;
        return this.level == r.level && Objects.equals(this.id, r.id) && Objects.equals(this.displayName, r.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.level, this.displayName);
    }
}

