/*
 * Decompiled with CFR 0.152.
 */
package io.github.lijinhong11.supermines.api.data;

import io.github.lijinhong11.supermines.api.data.Rank;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Column;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Converter;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.PrimaryKey;
import io.github.lijinhong11.supermines.libraries.database.serialization.annotations.Table;
import io.github.lijinhong11.supermines.managers.database.RankConverter;
import java.util.UUID;

@Table(name="player_data")
public final class PlayerData {
    @Column(name="player_uuid")
    @PrimaryKey
    private UUID playerUUID;
    @Column(name="player_name")
    private String playerName;
    @Column(name="mined_blocks")
    private int minedBlocks;
    @Converter(value=RankConverter.class)
    @Column(name="rank")
    private Rank rank;

    public PlayerData() {
    }

    public PlayerData(String playerName, UUID playerUUID, Rank rank) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
        this.rank = rank;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    public int getMinedBlocks() {
        return this.minedBlocks;
    }

    public void addMinedBlocks(int amount) {
        this.minedBlocks += amount;
    }
}

