/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XAttribute;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.storage.PlayerStorage;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ModuleAttackCooldown
extends OCMModule {
    private final double NEW_ATTACK_SPEED = 4.0;

    public ModuleAttackCooldown(OCMMain plugin) {
        super(plugin, "disable-attack-cooldown");
    }

    @Override
    public void reload() {
        Bukkit.getOnlinePlayers().forEach(this::adjustAttackSpeed);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(PlayerJoinEvent e) {
        this.adjustAttackSpeed(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.adjustAttackSpeed(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.setAttackSpeed(e.getPlayer(), 4.0);
    }

    private void adjustAttackSpeed(Player player) {
        double attackSpeed = this.isEnabled((HumanEntity)player) ? this.module().getDouble("generic-attack-speed") : 4.0;
        this.setAttackSpeed(player, attackSpeed);
    }

    @Override
    public void onModesetChange(Player player) {
        this.adjustAttackSpeed(player);
    }

    public void setAttackSpeed(Player player, double attackSpeed) {
        AttributeInstance attribute = player.getAttribute((Attribute)XAttribute.ATTACK_SPEED.get());
        if (attribute == null) {
            return;
        }
        double baseValue = attribute.getBaseValue();
        String modesetName = PlayerStorage.getPlayerData(player.getUniqueId()).getModesetForWorld(player.getWorld().getUID());
        this.debug(String.format("Setting attack speed to %.2f (was: %.2f) for %s in mode %s", attackSpeed, baseValue, player.getName(), modesetName));
        if (baseValue != attackSpeed) {
            this.debug(String.format("Setting attack speed to %.2f (was: %.2f)", attackSpeed, baseValue), (CommandSender)player);
            attribute.setBaseValue(attackSpeed);
            player.saveData();
        }
    }
}

