/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.play.server;

import java.util.Optional;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketSendEvent;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.packettype.PacketType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.world.WorldBlockPosition;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.resources.ResourceLocation;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.Vector3i;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WrapperPlayServerSpawnPosition
extends PacketWrapper<WrapperPlayServerSpawnPosition> {
    private ResourceLocation dimension;
    private Vector3i position;
    private float yaw;
    private float pitch;

    public WrapperPlayServerSpawnPosition(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerSpawnPosition(Vector3i position) {
        this(position, 0.0f);
    }

    public WrapperPlayServerSpawnPosition(Vector3i position, float yaw) {
        this(WorldBlockPosition.OVERWORLD_DIMENSION, position, yaw, 0.0f);
    }

    public WrapperPlayServerSpawnPosition(ResourceLocation dimension, Vector3i position, float yaw, float pitch) {
        super(PacketType.Play.Server.SPAWN_POSITION);
        this.dimension = dimension;
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            this.dimension = ResourceLocation.read(this);
        }
        Vector3i vector3i = this.position = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8) ? this.readBlockPosition() : new Vector3i(this.readInt(), this.readInt(), this.readInt());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.yaw = this.readFloat();
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            this.pitch = this.readFloat();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            ResourceLocation.write(this, this.dimension);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.writeBlockPosition(this.position);
        } else {
            this.writeInt(this.position.x);
            this.writeInt(this.position.y);
            this.writeInt(this.position.z);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeFloat(this.yaw);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            this.writeFloat(this.pitch);
        }
    }

    @Override
    public void copy(WrapperPlayServerSpawnPosition wrapper) {
        this.dimension = wrapper.dimension;
        this.position = wrapper.position;
        this.yaw = wrapper.yaw;
        this.pitch = wrapper.pitch;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public void setPosition(Vector3i position) {
        this.position = position;
    }

    @Deprecated
    public Optional<Float> getAngle() {
        return Optional.ofNullable(Float.valueOf(this.yaw));
    }

    @Deprecated
    public void setAngle(float yaw) {
        this.yaw = yaw;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }
}

