/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.play.server;

import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketSendEvent;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.manager.server.ServerVersion;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.packettype.PacketType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.util.LpVector3d;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.util.Vector3d;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.PacketWrapper;

public class WrapperPlayServerEntityVelocity
extends PacketWrapper<WrapperPlayServerEntityVelocity> {
    private static final double PRECISION_LOSS_FIX = 1.0E-11;
    private int entityID;
    private Vector3d velocity;

    public WrapperPlayServerEntityVelocity(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityVelocity(int entityID, Vector3d velocity) {
        super(PacketType.Play.Server.ENTITY_VELOCITY);
        this.entityID = entityID;
        this.velocity = velocity;
    }

    @Override
    public void read() {
        int n = this.entityID = this.serverVersion.isOlderThan(ServerVersion.V_1_8) ? this.readInt() : this.readVarInt();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            this.velocity = LpVector3d.read(this);
        } else {
            double velX = (double)this.readShort() / 8000.0;
            double velY = (double)this.readShort() / 8000.0;
            double velZ = (double)this.readShort() / 8000.0;
            this.velocity = new Vector3d(velX, velY, velZ);
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThan(ServerVersion.V_1_8)) {
            this.writeInt(this.entityID);
        } else {
            this.writeVarInt(this.entityID);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
            LpVector3d.write(this, this.velocity);
        } else {
            this.writeShort((int)(this.velocity.x * 8000.0 + Math.copySign(1.0E-11, this.velocity.x)));
            this.writeShort((int)(this.velocity.y * 8000.0 + Math.copySign(1.0E-11, this.velocity.y)));
            this.writeShort((int)(this.velocity.z * 8000.0 + Math.copySign(1.0E-11, this.velocity.z)));
        }
    }

    @Override
    public void copy(WrapperPlayServerEntityVelocity wrapper) {
        this.entityID = wrapper.entityID;
        this.velocity = wrapper.velocity;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3d velocity) {
        this.velocity = velocity;
    }
}

