/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.reflection;

import java.util.function.BiFunction;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;

public class SpigotFunctionChooser<T, U, R> {
    private final BiFunction<T, U, Boolean> test;
    private final BiFunction<T, U, R> trueBranch;
    private final BiFunction<T, U, R> falseBranch;
    private BiFunction<T, U, R> chosen;

    public SpigotFunctionChooser(BiFunction<T, U, Boolean> test, BiFunction<T, U, R> trueBranch, BiFunction<T, U, R> falseBranch) {
        this.test = test;
        this.trueBranch = trueBranch;
        this.falseBranch = falseBranch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(T target, U parameters) {
        if (this.chosen == null) {
            SpigotFunctionChooser spigotFunctionChooser = this;
            synchronized (spigotFunctionChooser) {
                if (this.chosen == null) {
                    this.chosen = this.test.apply(target, parameters) != false ? this.trueBranch : this.falseBranch;
                }
            }
        }
        return this.chosen.apply(target, parameters);
    }

    public R apply(T target) {
        return this.apply(target, new Object[0]);
    }

    private static <T, U, R> SpigotFunctionChooser<T, U, R> onException(ExceptionalFunction<T, U, R> action, BiFunction<T, U, R> success, BiFunction<T, U, R> failure) {
        return new SpigotFunctionChooser<Object, Object, R>((t, u) -> {
            try {
                action.apply(t, u);
                return true;
            }
            catch (ExceptionalFunction.WrappedException e) {
                Throwable failureCause = SpigotFunctionChooser.rootCause(e);
                if (SpigotFunctionChooser.isCompatibilityFailure(failureCause)) {
                    return false;
                }
                throw SpigotFunctionChooser.propagate(failureCause);
            }
        }, success, failure);
    }

    private static Throwable rootCause(Throwable throwable) {
        Throwable current;
        for (current = throwable; current.getCause() != null && current.getCause() != current; current = current.getCause()) {
        }
        return current;
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }

    private static boolean isCompatibilityFailure(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof LinkageError) {
            return true;
        }
        if (throwable instanceof NoSuchMethodException || throwable instanceof ClassNotFoundException) {
            return true;
        }
        if (throwable instanceof UnsupportedOperationException) {
            return SpigotFunctionChooser.isApprovedUnsupportedOperation((UnsupportedOperationException)throwable);
        }
        return false;
    }

    private static boolean isApprovedUnsupportedOperation(UnsupportedOperationException exception) {
        String className = exception.getClass().getSimpleName();
        if (className != null && className.toLowerCase().startsWith("compat")) {
            return true;
        }
        String message = exception.getMessage();
        if (message == null) {
            return false;
        }
        String normalised = message.toLowerCase();
        return normalised.matches(".*(^|[^a-z])compat(ibility)?([^a-z]|$).*");
    }

    public static <T, U, R> SpigotFunctionChooser<T, U, R> apiCompatReflectionCall(ExceptionalFunction<T, U, R> apiCall, Class<T> clazz, String name, String ... argTypes) {
        return SpigotFunctionChooser.onException(apiCall, apiCall, Reflector.memoiseMethodInvocation(clazz, name, argTypes));
    }

    public static <T, U, R> SpigotFunctionChooser<T, U, R> apiCompatCall(ExceptionalFunction<T, U, R> apiCall, BiFunction<T, U, R> altFunc) {
        return SpigotFunctionChooser.onException(apiCall, apiCall, altFunc);
    }

    @FunctionalInterface
    public static interface ExceptionalFunction<T, U, R>
    extends BiFunction<T, U, R> {
        public R applyWithException(T var1, U var2) throws Throwable;

        @Override
        default public R apply(T t, U u) {
            try {
                return this.applyWithException(t, u);
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
        }

        public static class WrappedException
        extends RuntimeException {
            WrappedException(Throwable cause) {
                super(cause);
            }
        }
    }
}

