/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.AttackCooldownTracker;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.SpigotFunctionChooser;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DamageUtils {
    private static final SpigotFunctionChooser<LivingEntity, Object, Boolean> isInWater = SpigotFunctionChooser.apiCompatCall((le, params) -> le.isInWater(), (le, params) -> le.getLocation().getBlock().getType() == Material.WATER);
    private static final SpigotFunctionChooser<LivingEntity, Object, Boolean> isClimbing = SpigotFunctionChooser.apiCompatCall((le, params) -> le.isClimbing(), (le, params) -> {
        Material material = le.getLocation().getBlock().getType();
        return material == Material.LADDER || material == Material.VINE;
    });
    public static final SpigotFunctionChooser<HumanEntity, Object, Float> getAttackCooldown = SpigotFunctionChooser.apiCompatCall((he, params) -> Float.valueOf(he.getAttackCooldown()), (he, params) -> Float.valueOf(DamageUtils.getAttackCooldown(he)));

    private static float getAttackCooldown(HumanEntity humanEntity) {
        Float cooldown = AttackCooldownTracker.getLastCooldown(humanEntity.getUniqueId());
        if (cooldown == null) {
            Messenger.debug("Last attack cooldown null for " + humanEntity.getName() + ", assuming full attack strength", new Object[0]);
            return 1.0f;
        }
        return cooldown.floatValue();
    }

    public static double getNewSharpnessDamage(int level) {
        return level >= 1 ? 1.0 + (double)(level - 1) * 0.5 : 0.0;
    }

    public static double getOldSharpnessDamage(int level) {
        return level >= 1 ? (double)level * 1.25 : 0.0;
    }

    public static boolean isCriticalHit1_8(HumanEntity humanEntity) {
        return humanEntity.getFallDistance() > 0.0f && !humanEntity.isOnGround() && isClimbing.apply((LivingEntity)humanEntity) == false && isInWater.apply((LivingEntity)humanEntity) == false && humanEntity.getActivePotionEffects().stream().map(PotionEffect::getType).noneMatch(e -> e == PotionEffectType.BLINDNESS) && !humanEntity.isInsideVehicle();
    }

    public static boolean isCriticalHit1_9(Player player) {
        return DamageUtils.isCriticalHit1_8((HumanEntity)player) && getAttackCooldown.apply((HumanEntity)player).floatValue() > 0.9f && !player.isSprinting();
    }
}

