/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.damage;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.VersionCompatUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AttackCooldownTracker
extends OCMModule {
    private static AttackCooldownTracker INSTANCE;
    private final Map<UUID, Float> lastCooldown = new HashMap<UUID, Float>();

    public AttackCooldownTracker(OCMMain plugin) {
        super(plugin, "attack-cooldown-tracker");
        if (Reflector.getMethod(HumanEntity.class, "getAttackCooldown", 0) != null) {
            INSTANCE = null;
            return;
        }
        INSTANCE = this;
        Runnable cooldownTask = () -> Bukkit.getOnlinePlayers().forEach(player -> this.lastCooldown.put(player.getUniqueId(), Float.valueOf(VersionCompatUtils.getAttackCooldown((HumanEntity)player))));
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, cooldownTask, 0L, 1L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.lastCooldown.remove(event.getPlayer().getUniqueId());
    }

    public static Float getLastCooldown(UUID uuid) {
        AttackCooldownTracker instance = INSTANCE;
        if (instance == null) {
            return null;
        }
        return instance.lastCooldown.get(uuid);
    }
}

