/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XMaterial;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionDurations;
import kernitus.plugin.OldCombatMechanics.utilities.potions.PotionKey;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class ConfigUtils {
    private static final Set<String> warnedUnknownPotionDurationKeys = Collections.synchronizedSet(new HashSet());
    private static final Set<String> warnedUnknownMaterialListKeys = Collections.synchronizedSet(new HashSet());

    public static Map<String, Double> loadDoubleMap(ConfigurationSection section) {
        Objects.requireNonNull(section, "section cannot be null!");
        return section.getKeys(false).stream().filter(((Predicate<String>)arg_0 -> ((ConfigurationSection)section).isDouble(arg_0)).or(arg_0 -> ((ConfigurationSection)section).isInt(arg_0))).collect(Collectors.toMap(key -> key, arg_0 -> ((ConfigurationSection)section).getDouble(arg_0)));
    }

    public static List<Material> loadMaterialList(ConfigurationSection section, String key) {
        Objects.requireNonNull(section, "section cannot be null!");
        Objects.requireNonNull(key, "key cannot be null!");
        if (!section.isList(key)) {
            return new ArrayList<Material>();
        }
        String basePath = section.getCurrentPath();
        String fullKey = basePath == null || basePath.isEmpty() ? key : basePath + "." + key;
        return section.getStringList(key).stream().map(String::trim).map(name -> {
            Optional<XMaterial> match = XMaterial.matchXMaterial(name);
            if (!match.isPresent()) {
                ConfigUtils.warnUnknownMaterial(fullKey, name);
                return null;
            }
            Material material = match.get().parseMaterial();
            if (material == null) {
                ConfigUtils.warnUnknownMaterial(fullKey, name);
            }
            return material;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static void warnUnknownMaterial(String fullKey, String name) {
        String warnKey = fullKey + ":" + name.toUpperCase(Locale.ROOT);
        if (warnedUnknownMaterialListKeys.add(warnKey)) {
            Messenger.warn("Unknown material '%s' in config list '%s'; skipping", name, fullKey);
        }
    }

    public static HashMap<PotionKey, PotionDurations> loadPotionDurationsList(ConfigurationSection section) {
        Objects.requireNonNull(section, "potion durations section cannot be null!");
        HashMap<PotionKey, PotionDurations> durationsHashMap = new HashMap<PotionKey, PotionDurations>();
        ConfigurationSection durationsSection = section.getConfigurationSection("potion-durations");
        ConfigurationSection drinkableSection = durationsSection.getConfigurationSection("drinkable");
        ConfigurationSection splashSection = durationsSection.getConfigurationSection("splash");
        for (String newPotionTypeName : drinkableSection.getKeys(false)) {
            int drinkableDuration = drinkableSection.getInt(newPotionTypeName) * 20;
            int splashDuration = splashSection.getInt(newPotionTypeName) * 20;
            Optional<PotionKey> potionKey = PotionKey.fromConfigKey(newPotionTypeName);
            if (potionKey.isPresent()) {
                durationsHashMap.put(potionKey.get(), new PotionDurations(drinkableDuration, splashDuration));
                continue;
            }
            if (!warnedUnknownPotionDurationKeys.add(newPotionTypeName)) continue;
            Messenger.warn("Unknown potion type '%s' in old-potion-effects.potion-durations; skipping", newPotionTypeName);
        }
        return durationsHashMap;
    }
}

