/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kernitus.plugin.OldCombatMechanics.ModuleLoader;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.EntityDamageByEntityListener;
import kernitus.plugin.OldCombatMechanics.utilities.damage.WeaponDamages;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private static final String CONFIG_NAME = "config.yml";
    private static OCMMain plugin;
    private static FileConfiguration config;
    private static final Map<String, Set<String>> modesets;
    private static final Map<UUID, Set<String>> worlds;
    private static final Set<String> alwaysEnabledModules;
    private static final Set<String> disabledModules;
    private static final Set<String> optionalModules;
    private static final Set<String> internalModules;

    public static void initialise(OCMMain plugin) {
        Config.plugin = plugin;
        config = plugin.getConfig();
    }

    private static boolean checkConfigVersion() {
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getResource(CONFIG_NAME))));
        if (config.getInt("config-version") != defaultConfig.getInt("config-version")) {
            plugin.upgradeConfig();
            Config.reload();
            return true;
        }
        return false;
    }

    public static void reload() {
        if (plugin.doesConfigExist()) {
            plugin.reloadConfig();
            config = plugin.getConfig();
        } else {
            plugin.upgradeConfig();
        }
        if (Config.checkConfigVersion()) {
            return;
        }
        Messenger.reloadConfig(config.getBoolean("debug.enabled"), config.getString("message-prefix"));
        WeaponDamages.initialise(plugin);
        Config.reloadModesets();
        Config.reloadWorlds();
        EntityDamageByEntityListener EDBEL = EntityDamageByEntityListener.getINSTANCE();
        if (EDBEL != null) {
            EDBEL.setEnabled(Config.moduleEnabled("old-tool-damage") || Config.moduleEnabled("old-potion-effects") || Config.moduleEnabled("old-critical-hits"));
        }
        ModuleLoader.toggleModules();
        ModuleLoader.getModules().forEach(module -> {
            try {
                module.reload();
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error reloading module '" + module.toString() + "'", e);
            }
        });
    }

    private static void reloadModesets() {
        modesets.clear();
        alwaysEnabledModules.clear();
        disabledModules.clear();
        Set moduleNames = ModuleLoader.getModules().stream().map(OCMModule::getConfigName).map(Config::normaliseModuleName).collect(Collectors.toSet());
        HashSet knownModuleNames = new HashSet(moduleNames);
        knownModuleNames.addAll(optionalModules);
        HashSet configurableModuleNames = new HashSet(knownModuleNames);
        configurableModuleNames.removeAll(internalModules);
        ConfigurationSection modesetsSection = config.getConfigurationSection("modesets");
        if (modesetsSection == null) {
            throw new IllegalStateException("Missing 'modesets' section in config. Every module must be assigned to a modeset, always_enabled_modules, or disabled_modules.");
        }
        ArrayList<String> errors = new ArrayList<String>();
        HashSet modulesInModesets = new HashSet();
        List alwaysModules = config.getStringList("always_enabled_modules");
        for (Object moduleName : alwaysModules) {
            String normalised = Config.normaliseModuleName((String)moduleName);
            if (internalModules.contains(normalised)) {
                errors.add("Internal module should not be configured: " + moduleName);
                continue;
            }
            if (!configurableModuleNames.contains(normalised)) {
                Messenger.warn("Unknown module in always_enabled_modules: " + moduleName, new Object[0]);
                continue;
            }
            alwaysEnabledModules.add(normalised);
        }
        List disabledModuleList = config.getStringList("disabled_modules");
        for (String moduleName : disabledModuleList) {
            String normalised = Config.normaliseModuleName(moduleName);
            if (internalModules.contains(normalised)) {
                errors.add("Internal module should not be configured: " + moduleName);
                continue;
            }
            if (!configurableModuleNames.contains(normalised)) {
                Messenger.warn("Unknown module in disabled_modules: " + moduleName, new Object[0]);
                continue;
            }
            disabledModules.add(normalised);
        }
        for (String moduleName : alwaysEnabledModules) {
            if (!disabledModules.contains(moduleName)) continue;
            errors.add("Module listed in both always_enabled_modules and disabled_modules: " + moduleName);
        }
        for (String key : modesetsSection.getKeys(false)) {
            List moduleList = modesetsSection.getStringList(key);
            HashSet<String> moduleSet = new HashSet<String>();
            for (String moduleName : moduleList) {
                String normalised = Config.normaliseModuleName(moduleName);
                if (internalModules.contains(normalised)) {
                    errors.add("Internal module should not be configured: " + moduleName);
                    continue;
                }
                if (!configurableModuleNames.contains(normalised)) {
                    Messenger.warn("Unknown module in modeset '%s': %s", key, moduleName);
                    continue;
                }
                if (disabledModules.contains(normalised)) {
                    errors.add("Module listed in disabled_modules and modeset '" + key + "': " + moduleName);
                    continue;
                }
                if (alwaysEnabledModules.contains(normalised)) {
                    errors.add("Module listed in always_enabled_modules and modeset '" + key + "': " + moduleName);
                    continue;
                }
                moduleSet.add(normalised);
            }
            modesets.put(key, moduleSet);
            modulesInModesets.addAll(moduleSet);
        }
        for (String moduleName : configurableModuleNames) {
            if (disabledModules.contains(moduleName) || alwaysEnabledModules.contains(moduleName) || modulesInModesets.contains(moduleName)) continue;
            errors.add("Module not assigned to any list: " + moduleName);
        }
        if (!errors.isEmpty()) {
            String message = "Invalid module assignment configuration:\n - " + String.join((CharSequence)"\n - ", errors) + "\nEvery module must appear in exactly one of always_enabled_modules, disabled_modules, or modesets.";
            throw new IllegalStateException(message);
        }
        alwaysEnabledModules.addAll(internalModules);
    }

    private static void reloadWorlds() {
        worlds.clear();
        ConfigurationSection worldsSection = config.getConfigurationSection("worlds");
        for (String worldName : worldsSection.getKeys(false)) {
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                Messenger.warn("Configured world " + worldName + " not found, skipping (might be loaded later?)...", new Object[0]);
                continue;
            }
            Config.addWorld(world, worldsSection);
        }
    }

    public static void addWorld(World world) {
        ConfigurationSection worldsSection = config.getConfigurationSection("worlds");
        Config.addWorld(world, worldsSection);
    }

    public static void addWorld(World world, ConfigurationSection worldsSection) {
        LinkedHashSet modesetsSet = new LinkedHashSet(worldsSection.getStringList(world.getName()));
        worlds.put(world.getUID(), modesetsSet);
    }

    public static void removeWorld(World world) {
        worlds.remove(world.getUID());
    }

    @Nullable
    public static Set<String> getDefaultModeset(UUID worldId) {
        String modesetName;
        if (!worlds.containsKey(worldId)) {
            return null;
        }
        Set<String> set = worlds.get(worldId);
        if (set == null || set.isEmpty()) {
            return null;
        }
        Iterator<String> iterator = set.iterator();
        if (iterator.hasNext() && modesets.containsKey(modesetName = iterator.next())) {
            return modesets.get(modesetName);
        }
        return null;
    }

    public static boolean moduleEnabled(String moduleName, World world) {
        String normalised = Config.normaliseModuleName(moduleName);
        if (disabledModules.contains(normalised)) {
            return false;
        }
        if (alwaysEnabledModules.contains(normalised)) {
            return true;
        }
        if (world == null) {
            return Config.isModuleInAnyModeset(normalised);
        }
        Set<String> defaultModeset = Config.getDefaultModeset(world.getUID());
        if (defaultModeset == null) {
            return Config.isModuleInAnyModeset(normalised);
        }
        return defaultModeset.contains(normalised);
    }

    public static boolean moduleEnabled(String moduleName) {
        return Config.moduleEnabled(moduleName, null);
    }

    public static boolean debugEnabled() {
        return config.getBoolean("debug.enabled");
    }

    public static boolean moduleSettingEnabled(String moduleName, String moduleSettingName) {
        return config.getBoolean(moduleName + "." + moduleSettingName);
    }

    public static FileConfiguration getConfig() {
        return plugin.getConfig();
    }

    public static Map<String, Set<String>> getModesets() {
        return modesets;
    }

    public static boolean isModuleAlwaysEnabled(String moduleName) {
        return alwaysEnabledModules.contains(Config.normaliseModuleName(moduleName));
    }

    public static boolean isModuleDisabled(String moduleName) {
        return disabledModules.contains(Config.normaliseModuleName(moduleName));
    }

    public static boolean isModuleInAnyModeset(String moduleName) {
        return modesets.values().stream().anyMatch(set -> set.contains(Config.normaliseModuleName(moduleName)));
    }

    public static Map<UUID, Set<String>> getWorlds() {
        return worlds;
    }

    private static String normaliseModuleName(String moduleName) {
        return moduleName == null ? "" : moduleName.toLowerCase(Locale.ROOT);
    }

    static {
        modesets = new HashMap<String, Set<String>>();
        worlds = new HashMap<UUID, Set<String>>();
        alwaysEnabledModules = new HashSet<String>();
        disabledModules = new HashSet<String>();
        optionalModules = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("disable-attack-sounds", "disable-sword-sweep-particles")));
        internalModules = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("modeset-listener", "attack-cooldown-tracker", "entity-damage-listener")));
    }
}

