/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.paper;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PaperSwordBlocking {
    private static final float BLOCK_CONSUME_SECONDS = 1.6f;
    private final MethodHandle nmsApplyComponents;
    private final MethodHandle nmsSetComponent;
    private final MethodHandle nmsRemoveComponent;
    private final MethodHandle nmsGetComponentsPatch;
    private final MethodHandle nmsPatchGet;
    private final Object addConsumablePatch;
    private final Object removeConsumablePatch;
    private final Object nmsConsumableType;
    private final Object nmsConsumableComponent;
    private final Method paperSetDataValue;
    private final Method paperSetDataBuilder;
    private final Method paperUnsetData;
    private final Method paperHasData;
    private final Method paperEnsureServerConversions;
    private final Method paperCopyDataFrom;
    private final Object paperConsumableType;
    private final Object paperConsumableValue;
    private final Object paperBaseConsumable;
    private final Method paperBaseConsumableToBuilder;
    private final Method paperConsumableBuilderFactory;
    private final Class<?> paperUseAnimClass;
    private final Object paperBlockAnimation;
    private final Class<?> paperValuedTypeClass;
    private final Class<?> paperBuilderClass;
    private static final Predicate<Object> COPY_ALL_COMPONENTS = ignored -> true;
    private volatile Field craftItemStackHandleField;
    private final MethodHandle craftPlayerGetHandle;
    private final MethodHandle nmsGetUseItem;
    private final MethodHandle nmsItemStackIs;
    private final Object nmsSwordTag;

    public PaperSwordBlocking() throws Exception {
        Object swordTag;
        Object consumableType;
        Object consumableComponent;
        Class<?> nmsConsumable = Class.forName("net.minecraft.world.item.component.Consumable");
        Object nmsConsumableBuilder = nmsConsumable.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        Class<?> nmsUseAnim = Class.forName("net.minecraft.world.item.ItemUseAnimation");
        Object nmsBlockAnim = nmsUseAnim.getField("BLOCK").get(null);
        Object nmsConsumableValue = nmsConsumableBuilder.getClass().getMethod("consumeSeconds", Float.TYPE).invoke(nmsConsumableBuilder, Float.valueOf(Float.MAX_VALUE));
        Object nmsConsumableValue2 = nmsConsumableValue.getClass().getMethod("animation", nmsUseAnim).invoke(nmsConsumableValue, nmsBlockAnim);
        this.nmsConsumableComponent = consumableComponent = nmsConsumableValue2.getClass().getMethod("build", new Class[0]).invoke(nmsConsumableValue2, new Object[0]);
        Class<?> nmsDataComponents = Class.forName("net.minecraft.core.component.DataComponents");
        this.nmsConsumableType = consumableType = nmsDataComponents.getField("CONSUMABLE").get(null);
        Class<?> nmsPatch = Class.forName("net.minecraft.core.component.DataComponentPatch");
        Object patchBuilderAdd = nmsPatch.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        Method setMethod = this.findPatchSetMethod(patchBuilderAdd.getClass());
        setMethod.invoke(patchBuilderAdd, consumableType, consumableComponent);
        this.addConsumablePatch = patchBuilderAdd.getClass().getMethod("build", new Class[0]).invoke(patchBuilderAdd, new Object[0]);
        Object patchBuilderRemove = nmsPatch.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        Method removeMethod = this.findPatchRemoveMethod(patchBuilderRemove.getClass());
        removeMethod.invoke(patchBuilderRemove, consumableType);
        this.removeConsumablePatch = patchBuilderRemove.getClass().getMethod("build", new Class[0]).invoke(patchBuilderRemove, new Object[0]);
        Method setDataValueHandle = null;
        Method setDataBuilderHandle = null;
        Method unsetDataHandle = null;
        Method hasDataHandle = null;
        Method ensureServerConversionsHandle = null;
        Method copyDataFromHandle = null;
        Object consumableTypePaper = null;
        Object consumableValuePaper = null;
        Object baseConsumablePaper = null;
        Method baseConsumableToBuilder = null;
        Method consumableBuilderFactory = null;
        Class<?> useAnimClass = null;
        Object blockAnimation = null;
        Class<?> valuedTypeClass = null;
        Class<?> builderClass = null;
        try {
            Class<?> paperItemStack = Class.forName("org.bukkit.inventory.ItemStack");
            Class<?> paperDataComponentType = Class.forName("io.papermc.paper.datacomponent.DataComponentType");
            Class<?> paperDataComponentTypeValued = Class.forName("io.papermc.paper.datacomponent.DataComponentType$Valued");
            Class<?> paperDataComponentBuilder = Class.forName("io.papermc.paper.datacomponent.DataComponentBuilder");
            valuedTypeClass = paperDataComponentTypeValued;
            builderClass = paperDataComponentBuilder;
            Class<?> paperDataComponentTypes = Class.forName("io.papermc.paper.datacomponent.DataComponentTypes");
            consumableTypePaper = paperDataComponentTypes.getField("CONSUMABLE").get(null);
            Method getData = paperItemStack.getMethod("getData", paperDataComponentTypeValued);
            ItemStack bread = new ItemStack(Material.BREAD);
            baseConsumablePaper = getData.invoke((Object)bread, consumableTypePaper);
            useAnimClass = Class.forName("io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation");
            blockAnimation = useAnimClass.getField("BLOCK").get(null);
            if (baseConsumablePaper != null) {
                baseConsumableToBuilder = baseConsumablePaper.getClass().getMethod("toBuilder", new Class[0]);
            }
            Class<?> paperConsumable = Class.forName("io.papermc.paper.datacomponent.item.Consumable");
            consumableBuilderFactory = paperConsumable.getMethod("consumable", new Class[0]);
            Method setDataMethodValue = null;
            Method setDataMethodBuilder = null;
            for (Method m : paperItemStack.getMethods()) {
                if (!m.getName().equals("setData") || m.getParameterCount() != 2 || !paperDataComponentTypeValued.isAssignableFrom(m.getParameterTypes()[0])) continue;
                if (paperDataComponentBuilder.isAssignableFrom(m.getParameterTypes()[1])) {
                    setDataMethodBuilder = m;
                    continue;
                }
                setDataMethodValue = m;
            }
            if (setDataMethodValue != null || setDataMethodBuilder != null) {
                Method unset = paperItemStack.getMethod("unsetData", paperDataComponentType);
                Method has = paperItemStack.getMethod("hasData", paperDataComponentType);
                Method ensure = paperItemStack.getMethod("ensureServerConversions", new Class[0]);
                Method copyFrom = paperItemStack.getMethod("copyDataFrom", paperItemStack, Predicate.class);
                if (setDataMethodValue != null) {
                    setDataMethodValue.setAccessible(true);
                }
                if (setDataMethodBuilder != null) {
                    setDataMethodBuilder.setAccessible(true);
                }
                unset.setAccessible(true);
                has.setAccessible(true);
                ensure.setAccessible(true);
                copyFrom.setAccessible(true);
                setDataValueHandle = setDataMethodValue;
                setDataBuilderHandle = setDataMethodBuilder;
                unsetDataHandle = unset;
                hasDataHandle = has;
                ensureServerConversionsHandle = ensure;
                copyDataFromHandle = copyFrom;
            }
        }
        catch (Throwable ignored) {
            consumableTypePaper = null;
            consumableValuePaper = null;
            baseConsumablePaper = null;
            baseConsumableToBuilder = null;
            consumableBuilderFactory = null;
            useAnimClass = null;
            blockAnimation = null;
        }
        this.paperSetDataValue = setDataValueHandle;
        this.paperSetDataBuilder = setDataBuilderHandle;
        this.paperUnsetData = unsetDataHandle;
        this.paperHasData = hasDataHandle;
        this.paperEnsureServerConversions = ensureServerConversionsHandle;
        this.paperCopyDataFrom = copyDataFromHandle;
        this.paperConsumableType = consumableTypePaper;
        this.paperConsumableValue = consumableValuePaper;
        this.paperBaseConsumable = baseConsumablePaper;
        this.paperBaseConsumableToBuilder = baseConsumableToBuilder;
        this.paperConsumableBuilderFactory = consumableBuilderFactory;
        this.paperUseAnimClass = useAnimClass;
        this.paperBlockAnimation = blockAnimation;
        this.paperValuedTypeClass = valuedTypeClass;
        this.paperBuilderClass = builderClass;
        Class<?> nmsItemStack = Class.forName("net.minecraft.world.item.ItemStack");
        Method apply = nmsItemStack.getMethod("applyComponents", nmsPatch);
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        this.nmsApplyComponents = lookup.unreflect(apply);
        Class<?> nmsComponentType = Class.forName("net.minecraft.core.component.DataComponentType");
        this.nmsSetComponent = lookup.unreflect(this.findItemStackSetMethod(nmsItemStack, nmsComponentType));
        this.nmsRemoveComponent = lookup.unreflect(this.findItemStackRemoveMethod(nmsItemStack, nmsComponentType));
        this.nmsGetComponentsPatch = lookup.unreflect(nmsItemStack.getMethod("getComponentsPatch", new Class[0]));
        this.nmsPatchGet = lookup.unreflect(nmsPatch.getMethod("get", nmsComponentType));
        Class<?> craftPlayer = Class.forName("org.bukkit.craftbukkit.entity.CraftPlayer");
        this.craftPlayerGetHandle = lookup.unreflect(craftPlayer.getMethod("getHandle", new Class[0]));
        Class<?> nmsPlayer = Class.forName("net.minecraft.world.entity.player.Player");
        this.nmsGetUseItem = lookup.unreflect(nmsPlayer.getMethod("getUseItem", new Class[0]));
        this.nmsSwordTag = swordTag = Class.forName("net.minecraft.tags.ItemTags").getField("SWORDS").get(null);
        this.nmsItemStackIs = lookup.unreflect(this.findItemStackIsMethod(nmsItemStack, swordTag));
    }

    private Field resolveCraftItemStackHandleField(ItemStack stack) throws NoSuchFieldException {
        Field cached = this.craftItemStackHandleField;
        if (cached != null) {
            return cached;
        }
        for (Class<?> c = stack.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField("handle");
                f.setAccessible(true);
                this.craftItemStackHandleField = f;
                return f;
            }
            catch (NoSuchFieldException ignored) {
                continue;
            }
        }
        throw new NoSuchFieldException("No 'handle' field found on " + stack.getClass().getName());
    }

    private Method findPatchSetMethod(Class<?> builderClass) throws NoSuchMethodException {
        for (Method m : builderClass.getMethods()) {
            if (!m.getName().equals("set") || m.getParameterCount() != 2) continue;
            return m;
        }
        throw new NoSuchMethodException("DataComponentPatch.Builder#set(type, value) not found");
    }

    private Method findPatchRemoveMethod(Class<?> builderClass) throws NoSuchMethodException {
        for (Method m : builderClass.getMethods()) {
            if (!m.getName().equals("remove") || m.getParameterCount() != 1) continue;
            return m;
        }
        throw new NoSuchMethodException("DataComponentPatch.Builder#remove(type) not found");
    }

    private Method findItemStackIsMethod(Class<?> nmsItemStackClass, Object tagInstance) throws NoSuchMethodException {
        for (Method m : nmsItemStackClass.getMethods()) {
            if (!m.getName().equals("is") || m.getParameterCount() != 1 || m.getReturnType() != Boolean.TYPE) continue;
            Class<?> param = m.getParameterTypes()[0];
            if (tagInstance != null && param.isInstance(tagInstance)) {
                return m;
            }
            if (tagInstance != null && param.isAssignableFrom(tagInstance.getClass())) {
                return m;
            }
            if (!param.getName().contains("TagKey")) continue;
            return m;
        }
        throw new NoSuchMethodException("ItemStack#is(tag) not found");
    }

    public void applyComponents(ItemStack stack) {
        this.applyComponentsInternal(stack, true);
    }

    private void applyComponentsInternal(ItemStack stack, boolean allowTestSync) {
        Object builder;
        Object value;
        if (stack == null || stack.getType() == Material.AIR || !this.isSword(stack.getType())) {
            return;
        }
        boolean applied = false;
        if (this.paperSetDataValue != null && this.paperConsumableType != null) {
            Object object = value = this.paperConsumableValue != null ? this.paperConsumableValue : this.buildPaperConsumableValue();
            if (value != null) {
                try {
                    applied = this.setPaperDataValue(stack, value);
                }
                catch (Throwable ignored) {
                    applied = false;
                }
            }
        }
        if (!applied && this.paperSetDataBuilder != null && this.paperConsumableType != null && (builder = this.buildPaperConsumableBuilder()) != null) {
            try {
                applied = this.setPaperDataBuilder(stack, builder);
            }
            catch (Throwable ignored) {
                applied = false;
            }
        }
        if (!applied && this.paperConsumableType != null && this.paperValuedTypeClass != null && (value = this.buildPaperConsumableValue()) != null) {
            applied = this.setPaperDataValue(stack, value);
        }
        if (!applied && this.paperConsumableType != null && this.paperBuilderClass != null && (builder = this.buildPaperConsumableBuilder()) != null) {
            applied = this.setPaperDataBuilder(stack, builder);
        }
        if (applied) {
            this.ensureServerConversions(stack);
            if (allowTestSync) {
                this.syncTestInventories(stack);
            }
            return;
        }
        try {
            Field handleField = this.resolveCraftItemStackHandleField(stack);
            Object nms = handleField.get(stack);
            if (nms != null) {
                this.nmsSetComponent.invoke(nms, this.nmsConsumableType, this.nmsConsumableComponent);
            }
            this.ensureServerConversions(stack);
            if (allowTestSync) {
                this.syncTestInventories(stack);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clearComponents(ItemStack stack) {
        if (stack == null) {
            return;
        }
        boolean cleared = false;
        if (this.paperUnsetData != null && this.paperConsumableType != null) {
            try {
                this.paperUnsetData.invoke((Object)stack, this.paperConsumableType);
                cleared = true;
            }
            catch (Throwable ignored) {
                cleared = false;
            }
        }
        if (cleared) {
            this.ensureServerConversions(stack);
            return;
        }
        try {
            Field handleField = this.resolveCraftItemStackHandleField(stack);
            Object nms = handleField.get(stack);
            if (nms != null) {
                this.nmsRemoveComponent.invoke(nms, this.nmsConsumableType);
            }
            this.ensureServerConversions(stack);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Method findItemStackSetMethod(Class<?> nmsItemStackClass, Class<?> nmsComponentTypeClass) throws NoSuchMethodException {
        for (Method m : nmsItemStackClass.getMethods()) {
            if (!m.getName().equals("set") || m.getParameterCount() != 2 || !m.getParameterTypes()[0].isAssignableFrom(nmsComponentTypeClass)) continue;
            return m;
        }
        throw new NoSuchMethodException("ItemStack#set(component, value) not found");
    }

    private Method findItemStackRemoveMethod(Class<?> nmsItemStackClass, Class<?> nmsComponentTypeClass) throws NoSuchMethodException {
        for (Method m : nmsItemStackClass.getMethods()) {
            if (!m.getName().equals("remove") || m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(nmsComponentTypeClass)) continue;
            return m;
        }
        throw new NoSuchMethodException("ItemStack#remove(component) not found");
    }

    public boolean hasConsumableComponent(ItemStack stack) {
        if (stack == null || stack.getType() == Material.AIR || !this.isSword(stack.getType())) {
            return false;
        }
        if (this.paperHasData != null && this.paperConsumableType != null) {
            try {
                Object result = this.paperHasData.invoke((Object)stack, this.paperConsumableType);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
            }
            catch (Throwable result) {
                // empty catch block
            }
        }
        try {
            Field handleField = this.resolveCraftItemStackHandleField(stack);
            Object nms = handleField.get(stack);
            if (nms == null) {
                return false;
            }
            Object patch = this.nmsGetComponentsPatch.invoke(nms);
            if (patch == null) {
                return false;
            }
            Object entry = this.nmsPatchGet.invoke(patch, this.nmsConsumableType);
            if (!(entry instanceof Optional)) {
                return false;
            }
            return ((Optional)entry).isPresent();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void ensureServerConversions(ItemStack stack) {
        if (this.paperEnsureServerConversions == null || this.paperCopyDataFrom == null || stack == null) {
            return;
        }
        try {
            Object converted = this.paperEnsureServerConversions.invoke((Object)stack, new Object[0]);
            if (!(converted instanceof ItemStack)) {
                return;
            }
            if (converted == stack) {
                return;
            }
            this.paperCopyDataFrom.invoke((Object)stack, converted, COPY_ALL_COMPONENTS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean setPaperDataValue(ItemStack stack, Object value) {
        if (stack == null || value == null || this.paperConsumableType == null) {
            return false;
        }
        try {
            Method method = this.paperSetDataValue;
            if (method == null && this.paperValuedTypeClass != null) {
                method = stack.getClass().getMethod("setData", this.paperValuedTypeClass, Object.class);
            }
            if (method == null) {
                return false;
            }
            method.invoke((Object)stack, this.paperConsumableType, value);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean setPaperDataBuilder(ItemStack stack, Object builder) {
        if (stack == null || builder == null || this.paperConsumableType == null || this.paperBuilderClass == null) {
            return false;
        }
        try {
            Method method = this.paperSetDataBuilder;
            if (method == null) {
                method = stack.getClass().getMethod("setData", this.paperValuedTypeClass, this.paperBuilderClass);
            }
            if (method == null) {
                return false;
            }
            method.invoke((Object)stack, this.paperConsumableType, builder);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private Object buildPaperConsumableBuilder() {
        if (this.paperConsumableType == null || this.paperUseAnimClass == null || this.paperBlockAnimation == null) {
            return null;
        }
        try {
            Object builder = null;
            boolean fromBase = false;
            if (this.paperBaseConsumable != null && this.paperBaseConsumableToBuilder != null) {
                builder = this.paperBaseConsumableToBuilder.invoke(this.paperBaseConsumable, new Object[0]);
                fromBase = true;
            }
            if (builder == null && this.paperConsumableBuilderFactory != null) {
                builder = this.paperConsumableBuilderFactory.invoke(null, new Object[0]);
                fromBase = false;
            }
            if (builder == null) {
                return null;
            }
            Object configured = builder;
            if (!fromBase) {
                configured = configured.getClass().getMethod("consumeSeconds", Float.TYPE).invoke(configured, Float.valueOf(1.6f));
            }
            Object withAnim = configured.getClass().getMethod("animation", this.paperUseAnimClass).invoke(configured, this.paperBlockAnimation);
            return withAnim;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private Object buildPaperConsumableValue() {
        Object builder = this.buildPaperConsumableBuilder();
        if (builder == null) {
            return null;
        }
        try {
            return builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private void syncTestInventories(ItemStack stack) {
        if (!this.isTestServer() || stack == null) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerInventory inventory = player.getInventory();
            int size = inventory.getSize();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack candidate = inventory.getItem(slot);
                if (candidate == null || !candidate.isSimilar(stack)) continue;
                this.applyComponentsInternal(candidate, false);
                inventory.setItem(slot, candidate);
            }
            ItemStack cursor = player.getItemOnCursor();
            if (cursor == null || !cursor.isSimilar(stack)) continue;
            this.applyComponentsInternal(cursor, false);
            player.setItemOnCursor(cursor);
        }
    }

    private boolean isTestServer() {
        return Bukkit.getPluginManager().getPlugin("OldCombatMechanicsTest") != null;
    }

    public boolean isBlockingSword(Player player) {
        if (player == null) {
            return false;
        }
        try {
            Object nmsPlayer = this.craftPlayerGetHandle.invoke(player);
            if (nmsPlayer == null) {
                return false;
            }
            Object useItem = this.nmsGetUseItem.invoke(nmsPlayer);
            if (useItem == null) {
                return false;
            }
            return this.nmsItemStackIs.invoke(useItem, this.nmsSwordTag);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean isSword(Material mat) {
        return mat != null && mat.name().endsWith("_SWORD");
    }
}

