/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.PacketEvents;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketListenerAbstract;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.event.PacketSendEvent;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.packettype.PacketType;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.Particle;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.protocol.particle.type.ParticleTypes;
import kernitus.plugin.OldCombatMechanics.lib.packetevents.api.wrapper.play.server.WrapperPlayServerParticle;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ModuleSwordSweepParticles
extends OCMModule {
    private final ParticleListener particleListener = new ParticleListener();

    public ModuleSwordSweepParticles(OCMMain plugin) {
        super(plugin, "disable-sword-sweep-particles");
        this.reload();
    }

    @Override
    public void reload() {
        if (this.isEnabled()) {
            PacketEvents.getAPI().getEventManager().registerListener(this.particleListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener(this.particleListener);
        }
    }

    private class ParticleListener
    extends PacketListenerAbstract {
        private boolean disabledDueToError;

        private ParticleListener() {
        }

        @Override
        public void onPacketSend(PacketSendEvent packetEvent) {
            if (this.disabledDueToError || packetEvent.isCancelled()) {
                return;
            }
            try {
                if (!PacketType.Play.Server.PARTICLE.equals(packetEvent.getPacketType())) {
                    return;
                }
                Object playerObject = packetEvent.getPlayer();
                if (!(playerObject instanceof Player)) {
                    return;
                }
                Player player = (Player)playerObject;
                if (!ModuleSwordSweepParticles.this.isEnabled((HumanEntity)player)) {
                    return;
                }
                WrapperPlayServerParticle wrapper = new WrapperPlayServerParticle(packetEvent);
                Particle<?> particle = wrapper.getParticle();
                if (particle == null || particle.getType() == null) {
                    return;
                }
                if (particle.getType() == ParticleTypes.SWEEP_ATTACK) {
                    packetEvent.setCancelled(true);
                    ModuleSwordSweepParticles.this.debug("Cancelled sweep particles", (CommandSender)player);
                }
            }
            catch (Exception | ExceptionInInitializerError e) {
                this.disabledDueToError = true;
                Messenger.warn(e, "Error detecting sweep packets. Please report it along with the following exception on github.Sweep cancellation should still work, but particles might show up.", new Object[0]);
            }
        }
    }
}

