/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.lib.xseries.XEnchantment;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.damage.NewWeaponDamage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ModuleSwordSweep
extends OCMModule {
    private final Set<UUID> sweepPrimedAttackers = new HashSet<UUID>();
    private EntityDamageEvent.DamageCause sweepDamageCause;
    private BukkitTask pendingClearTask;

    public ModuleSwordSweep(OCMMain plugin) {
        super(plugin, "disable-sword-sweep");
        try {
            this.sweepDamageCause = EntityDamageEvent.DamageCause.valueOf((String)"ENTITY_SWEEP_ATTACK");
        }
        catch (IllegalArgumentException e) {
            this.sweepDamageCause = null;
        }
        this.reload();
    }

    @Override
    public void reload() {
        if (this.sweepDamageCause != null) {
            return;
        }
        if (this.pendingClearTask != null) {
            this.pendingClearTask.cancel();
            this.pendingClearTask = null;
        }
        this.sweepPrimedAttackers.clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamaged(EntityDamageByEntityEvent e) {
        Entity damager = e.getDamager();
        if (!(damager instanceof Player)) {
            return;
        }
        if (!this.isEnabled(damager, e.getEntity())) {
            return;
        }
        if (this.sweepDamageCause != null) {
            if (e.getCause() == this.sweepDamageCause) {
                e.setCancelled(true);
                this.debug("Sweep cancelled", (CommandSender)damager);
            }
            return;
        }
        Player attacker = (Player)e.getDamager();
        ItemStack weapon = attacker.getInventory().getItemInMainHand();
        if (this.isHoldingSword(weapon.getType())) {
            this.onSwordAttack(e, attacker, weapon);
        }
    }

    private void onSwordAttack(EntityDamageByEntityEvent e, Player attacker, ItemStack weapon) {
        Float baseDamage;
        int level = 0;
        Enchantment sweepingEdge = XEnchantment.SWEEPING_EDGE.getEnchant();
        if (sweepingEdge != null) {
            level = weapon.getEnchantmentLevel(sweepingEdge);
        }
        if ((baseDamage = NewWeaponDamage.getDamageOrNull(weapon.getType())) == null) {
            this.debug("Unknown sword in NewWeaponDamage: " + weapon.getType() + " (passing through)", (CommandSender)attacker);
            return;
        }
        float damage = baseDamage.floatValue() * (float)level / (float)(level + 1) + 1.0f;
        if (e.getDamage() == (double)damage) {
            if (this.sweepPrimedAttackers.contains(attacker.getUniqueId())) {
                this.debug("Cancelling sweep...", (CommandSender)attacker);
                e.setCancelled(true);
            }
        } else {
            this.sweepPrimedAttackers.add(attacker.getUniqueId());
            this.scheduleClearNextTickIfNeeded();
        }
    }

    private void scheduleClearNextTickIfNeeded() {
        if (this.pendingClearTask != null) {
            return;
        }
        this.pendingClearTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.sweepPrimedAttackers.clear();
            this.pendingClearTask = null;
        }, 1L);
    }

    private boolean isHoldingSword(Material mat) {
        return mat.toString().endsWith("_SWORD");
    }
}

