/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.SpigotFunctionChooser;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ModuleFishingRodVelocity
extends OCMModule {
    private Random random;
    private boolean hasDifferentGravity;
    private final Set<FishHook> activeHooks = new HashSet<FishHook>();
    private BukkitRunnable gravityTask;
    private final SpigotFunctionChooser<PlayerFishEvent, Object, FishHook> getHook = SpigotFunctionChooser.apiCompatReflectionCall((e, params) -> e.getHook(), PlayerFishEvent.class, "getHook", new String[0]);

    public ModuleFishingRodVelocity(OCMMain plugin) {
        super(plugin, "fishing-rod-velocity");
        this.reload();
    }

    @Override
    public void reload() {
        this.random = new Random();
        this.hasDifferentGravity = Reflector.versionIsNewerOrEqualTo(1, 14, 0);
        if (this.gravityTask != null) {
            this.gravityTask.cancel();
            this.gravityTask = null;
        }
        this.activeHooks.clear();
    }

    @EventHandler(ignoreCancelled=true)
    public void onFishEvent(PlayerFishEvent event) {
        FishHook fishHook = this.getHook.apply(event);
        Player player = event.getPlayer();
        if (!this.isEnabled((HumanEntity)player) || event.getState() != PlayerFishEvent.State.FISHING) {
            return;
        }
        Location location = event.getPlayer().getLocation();
        double playerYaw = location.getYaw();
        double playerPitch = location.getPitch();
        float oldMaxVelocity = 0.4f;
        double velocityX = -Math.sin(playerYaw / 180.0 * 3.1415927410125732) * Math.cos(playerPitch / 180.0 * 3.1415927410125732) * (double)0.4f;
        double velocityZ = Math.cos(playerYaw / 180.0 * 3.1415927410125732) * Math.cos(playerPitch / 180.0 * 3.1415927410125732) * (double)0.4f;
        double velocityY = -Math.sin(playerPitch / 180.0 * 3.1415927410125732) * (double)0.4f;
        double oldVelocityMultiplier = 1.5;
        double vectorLength = (float)Math.sqrt(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ);
        velocityX /= vectorLength;
        velocityY /= vectorLength;
        velocityZ /= vectorLength;
        velocityX += this.random.nextGaussian() * (double)0.0075f;
        velocityY += this.random.nextGaussian() * (double)0.0075f;
        velocityZ += this.random.nextGaussian() * (double)0.0075f;
        fishHook.setVelocity(new Vector(velocityX *= 1.5, velocityY *= 1.5, velocityZ *= 1.5));
        if (!this.hasDifferentGravity) {
            return;
        }
        this.activeHooks.add(fishHook);
        this.ensureGravityTask();
    }

    private void ensureGravityTask() {
        if (this.gravityTask != null) {
            return;
        }
        this.gravityTask = new BukkitRunnable(){

            public void run() {
                if (ModuleFishingRodVelocity.this.activeHooks.isEmpty()) {
                    this.cancel();
                    ModuleFishingRodVelocity.this.gravityTask = null;
                    return;
                }
                Iterator it = ModuleFishingRodVelocity.this.activeHooks.iterator();
                while (it.hasNext()) {
                    FishHook hook = (FishHook)it.next();
                    if (hook == null || !hook.isValid() || hook.isOnGround()) {
                        it.remove();
                        continue;
                    }
                    if (hook.isInWater() || hook.getWorld().getBlockAt(hook.getLocation()).getType() == Material.WATER) continue;
                    Vector fVelocity = hook.getVelocity();
                    fVelocity.setY(fVelocity.getY() - 0.01);
                    hook.setVelocity(fVelocity);
                }
                if (ModuleFishingRodVelocity.this.activeHooks.isEmpty()) {
                    this.cancel();
                    ModuleFishingRodVelocity.this.gravityTask = null;
                }
            }
        };
        this.gravityTask.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

